/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Point;
import java.awt.Rectangle;
import ru.biosoft.graphics.SimplePath;

public class PathUtils {
    public static boolean lineIntersects(int x1, int y1, int x2, int y2, Rectangle rect) {
        if (PathUtils.horizontalLineIntersect(x1, y1, x2, y2, rect.x, rect.x + rect.width, rect.y)) {
            return true;
        }
        if (PathUtils.horizontalLineIntersect(x1, y1, x2, y2, rect.x, rect.x + rect.width, rect.y + rect.height)) {
            return true;
        }
        if (PathUtils.verticalLineIntersect(x1, y1, x2, y2, rect.x, rect.y, rect.y + rect.height)) {
            return true;
        }
        return PathUtils.verticalLineIntersect(x1, y1, x2, y2, rect.x + rect.width, rect.y, rect.y + rect.height);
    }

    protected static boolean horizontalLineIntersect(int x1, int y1, int x2, int y2, int lineX1, int lineX2, int lineY) {
        if (lineY < Math.min(y1, y2) || lineY > Math.max(y1, y2) || y1 == y2) {
            return false;
        }
        int x = x1 + (x2 - x1) * (lineY - y1) / (y2 - y1);
        return x >= lineX1 && x <= lineX2;
    }

    protected static boolean verticalLineIntersect(int x1, int y1, int x2, int y2, int lineX, int lineY1, int lineY2) {
        if (lineX < Math.min(x1, x2) || lineX > Math.max(x1, x2) || x1 == x2) {
            return false;
        }
        int y = y1 + (y2 - y1) * (lineX - x1) / (x2 - x1);
        return y >= lineY1 && y <= lineY2;
    }

    public static int getNearestSegment(SimplePath path, Point point) {
        double recordDistance = Double.MAX_VALUE;
        int recordSegment = -1;
        for (int i = 0; i < path.npoints - 1; ++i) {
            double dist = (path.xpoints[i] - point.x) * (path.xpoints[i] - point.x) + (path.ypoints[i] - point.y) * (path.ypoints[i] - point.y);
            dist += (double)((path.xpoints[i + 1] - point.x) * (path.xpoints[i + 1] - point.x) + (path.ypoints[i + 1] - point.y) * (path.ypoints[i + 1] - point.y));
            if (!((dist /= (double)((path.xpoints[i + 1] - path.xpoints[i]) * (path.xpoints[i + 1] - path.xpoints[i]) + (path.ypoints[i + 1] - path.ypoints[i]) * (path.ypoints[i + 1] - path.ypoints[i]))) < recordDistance)) continue;
            recordDistance = dist;
            recordSegment = i;
        }
        return recordSegment;
    }
}

