/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.View;

public class LineView
extends View {
    protected Pen pen = null;

    public LineView(JSONObject jsonObj) {
        super(null);
        this.initFromJSON(jsonObj);
    }

    public LineView(Pen pen, Point2D pt0, Point2D pt1) {
        super(new Line2D.Float(pt0, pt1));
        this.pen = pen;
    }

    public LineView(Pen pen, float X1, float Y1, float X2, float Y2) {
        this(pen, new Point2D.Float(X1, Y1), new Point2D.Float(X2, Y2));
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rect = (Rectangle)super.getBounds().clone();
        if (this.pen != null) {
            rect.grow((int)Math.ceil(this.pen.getWidth() / 2.0), (int)Math.ceil(this.pen.getWidth() / 2.0));
        }
        return rect;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LineView)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LineView v = (LineView)obj;
        return (this.pen != null || v.pen == null) && (this.pen == null || this.pen.equals(v.pen));
    }

    @Override
    public void move(int sx, int sy) {
        ((Line2D.Float)this.shape).x1 += (float)sx;
        ((Line2D.Float)this.shape).x2 += (float)sx;
        ((Line2D.Float)this.shape).y1 += (float)sy;
        ((Line2D.Float)this.shape).y2 += (float)sy;
    }

    @Override
    public void setToScale(double sx, double sy) {
        super.setToScale(sx, sy);
        if (this.pen != null) {
            float w = (float)(this.pen.getWidth() * sx);
            this.pen.setWidth(w);
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.pen != null && this.isVisible()) {
            g2.setColor(this.pen.color);
            g2.setStroke(this.pen.getStroke());
            g2.draw(this.shape);
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        if (this.pen != null) {
            result.put("pen", (Object)this.pen.toJSON());
        }
        Line2D.Float pos = (Line2D.Float)this.shape;
        result.put("x1", (double)pos.x1);
        result.put("y1", (double)pos.y1);
        result.put("x2", (double)pos.x2);
        result.put("y2", (double)pos.y2);
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        try {
            if (from.has("pen")) {
                this.pen = new Pen(from.getJSONObject("pen"));
            }
            double x1 = from.getDouble("x1");
            double y1 = from.getDouble("y1");
            double x2 = from.getDouble("x2");
            double y2 = from.getDouble("y2");
            this.shape = new Line2D.Float((float)x1, (float)y1, (float)x2, (float)y2);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

