/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.View;

public class ImageView
extends View
implements ImageObserver {
    protected Image image;
    protected String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ImageView(Image image, int x, int y, int width, int height) {
        super(new Rectangle(x, y, width, height));
        this.image = image;
        this.validateImageSize();
        this.at.setToTranslation(x, y);
    }

    public ImageView(Image image, int x, int y) {
        this(image, x, y, 0, 0);
    }

    @Override
    public boolean imageUpdate(Image img, int info, int x, int y, int width, int height) {
        return info != 32;
    }

    protected void validateImageSize() {
        Rectangle rect = (Rectangle)this.shape;
        if (rect.width < 1 || rect.height < 1) {
            rect.width = this.image.getWidth(this);
            rect.height = this.image.getHeight(this);
        }
    }

    @Override
    public void move(int tx, int ty) {
        Rectangle rect = (Rectangle)this.shape;
        rect.setFrame(rect.getX() + (double)tx, rect.getY() + (double)ty, rect.getWidth(), rect.getHeight());
        this.at.setTransform(this.at.getScaleX(), this.at.getShearX(), this.at.getShearY(), this.at.getScaleY(), rect.x, rect.y);
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.isVisible()) {
            g2.drawImage(this.image, this.at, this);
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        Rectangle pos = (Rectangle)this.shape;
        result.put("x", pos.x);
        result.put("y", pos.y);
        result.put("width", pos.width);
        result.put("height", pos.height);
        result.put("path", (Object)this.path);
        return result;
    }
}

