/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

public class HtmlView
extends View {
    private static final JComponent component = new JLabel();
    protected javax.swing.text.View view;
    protected String text;
    protected Point pt;
    protected ColorFont cf;

    public HtmlView(String text, ColorFont cf, Point pt) {
        this(text, cf, pt, null);
    }

    public HtmlView(String text, ColorFont cf, Point pt, Dimension preferredSize) {
        super(null);
        component.setFont(cf.getFont());
        component.setForeground(cf.getColor());
        this.view = BasicHTML.createHTMLView(component, text);
        this.text = text;
        this.cf = cf;
        this.pt = pt;
        if (preferredSize == null) {
            preferredSize = new Dimension();
            preferredSize.width = Math.round(this.view.getPreferredSpan(0));
            preferredSize.height = Math.round(this.view.getPreferredSpan(1));
        }
        preferredSize.width = Math.round(Math.max((float)preferredSize.width, this.view.getMinimumSpan(0)));
        preferredSize.height = Math.round(Math.max((float)preferredSize.height, this.view.getMinimumSpan(1)));
        this.view.setSize(preferredSize.width, preferredSize.height);
        this.shape = new Rectangle(pt, preferredSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HtmlView)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        HtmlView v = (HtmlView)obj;
        if (this.text == null && v.text != null || this.text != null && !this.text.equals(v.text)) {
            return false;
        }
        if (this.pt == null && v.pt != null || this.pt != null && !this.pt.equals(v.pt)) {
            return false;
        }
        return this.cf.getColor().equals(v.cf.getColor()) && this.cf.getFont().equals(v.cf.getFont());
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.isVisible()) {
            Shape oldClip = g2.getClip();
            g2.setClip(this.shape);
            this.view.paint(g2, this.shape);
            g2.setClip(oldClip);
        }
    }

    @Override
    public void move(int sx, int sy) {
        Rectangle rect = (Rectangle)this.shape;
        rect.setFrame(rect.getX() + (double)sx, rect.getY() + (double)sy, rect.getWidth(), rect.getHeight());
    }

    public void resize(int sx, int sy) {
        Rectangle rect = (Rectangle)this.shape;
        rect.setFrame(rect.getX(), rect.getY(), rect.getWidth() + (double)sx, rect.getHeight() + (double)sy);
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        result.put("text", (Object)this.text);
        result.put("font", (Object)this.cf.toJSON());
        result.put("x", this.shape.getBounds().x);
        result.put("y", this.shape.getBounds().y);
        result.put("width", this.shape.getBounds().width);
        result.put("height", this.shape.getBounds().height);
        return result;
    }

    public ColorFont getColorFont() {
        return this.cf;
    }

    public String getText() {
        return this.text;
    }
}

