/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.HtmlView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;

public class GraphicsUtils {
    public static boolean isNotDefault(Pen pen) {
        return pen != null && !Color.WHITE.equals(pen.getColor());
    }

    public static ComplexTextView getAsComplexTextView(HtmlView view) {
        Graphics2D graphics = ApplicationUtils.getGraphics();
        Rectangle rect = (Rectangle)view.getShape();
        HashMap<String, ColorFont> fontRegistry = new HashMap<String, ColorFont>();
        ColorFont cf = view.getColorFont();
        FontMetrics fm = graphics.getFontMetrics();
        String text = view.getText();
        return new ComplexTextView(text, new Point(rect.x, rect.y), 0, cf, fontRegistry, 12, rect.width * text.length() / fm.stringWidth(text), graphics);
    }
}

