/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Hashtable;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.util.LazyValue;

public class GraphicProperties {
    protected Hashtable<String, Object> _hs = new Hashtable();
    public final Pen penDefault = new Pen(1.0f, Color.black);
    public final Brush brushDefault = new Brush(Color.black);
    public final ColorFont fontDefault = new ColorFont(new Font("SansSerif", 0, 12), Color.black);
    public final Dimension marginDefault = new Dimension(5, 5);
    private static LazyValue<GraphicProperties> instance = new LazyValue("GraphicProperties", GraphicProperties::new);

    protected GraphicProperties() {
        this.setFont("Font_Title", new ColorFont(new Font("SansSerif", 0, 20), Color.black));
        this.setFont("Font_Bold_Title", new ColorFont(new Font("SansSerif", 1, 20), Color.black));
        this.setFont("Font_RulerDefault", new ColorFont(new Font("SansSerif", 0, 11), Color.black));
        this.setFont("Font_SequenceViewDefault", new ColorFont(new Font("Monospaced", 0, 14), Color.black));
        this.setFont("Font_SiteViewDefault", new ColorFont(new Font("Monospaced", 0, 14), Color.red));
        this.setFont("Font_SiteColorScheme", new ColorFont(new Font("SansSerif", 0, 12), Color.black));
        this.setFont("Font_RulerOverview", new ColorFont(new Font("Monospaced", 0, 10), Color.black));
        this.setFont("Font_SequenceViewOverview", new ColorFont(new Font("Monospaced", 0, 0), Color.black));
        this.setFont("Font_SiteViewOverview", new ColorFont(new Font("Monospaced", 0, 16), Color.red));
        this.setFont("Font_RulerDetailed", new ColorFont(new Font("Monospaced", 0, 14), Color.black));
        this.setFont("Font_SequenceViewDetailed", new ColorFont(new Font("Monospaced", 0, 14), Color.black));
        this.setFont("Font_SiteViewDetailed", new ColorFont(new Font("Monospaced", 0, 14), Color.red));
    }

    public Pen getPen(String penName) {
        Pen p;
        try {
            p = (Pen)this._hs.get(penName);
        }
        catch (Exception e) {
            p = this.penDefault;
        }
        return p;
    }

    public Brush getBrush(String brushName) {
        Brush b;
        try {
            b = (Brush)this._hs.get(brushName);
        }
        catch (Exception e) {
            b = this.brushDefault;
        }
        return b;
    }

    public ColorFont getFont(String fontName) {
        ColorFont f;
        try {
            f = (ColorFont)this._hs.get(fontName);
        }
        catch (Exception e) {
            f = this.fontDefault;
        }
        return f;
    }

    public Dimension getMargin(String marginName) {
        Dimension d;
        try {
            d = (Dimension)this._hs.get(marginName);
        }
        catch (Exception e) {
            d = this.marginDefault;
        }
        return d;
    }

    public void setPen(String penName, Pen pen) {
        this._hs.remove(penName);
        this._hs.put(penName, pen);
    }

    public void setBrush(String brushName, Brush brush) {
        this._hs.remove(brushName);
        this._hs.put(brushName, brush);
    }

    public void setFont(String fontName, ColorFont font) {
        this._hs.remove(fontName);
        this._hs.put(fontName, font);
    }

    public void setMargin(String marginName, Dimension margin) {
        this._hs.remove(marginName);
        this._hs.put(marginName, margin);
    }

    public static GraphicProperties getInstance() {
        return (GraphicProperties)instance.get();
    }
}

