/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;

public class GradientBorderedBoxView
extends BoxView {
    public static final int SIDE_NONE = 0;
    public static final int SIDE_RIGHT = 1;
    public static final int SIDE_LEFT = 2;
    public static final int SIDE_BOTH = 3;
    float gradientRadius;
    int side;

    public GradientBorderedBoxView(JSONObject jsonObj) {
        super((JSONObject)null);
        this.initFromJSON(jsonObj);
    }

    public GradientBorderedBoxView(Brush brush, float x, float y, float width, float height, float arcWidth, float arcHeight, float gradientRadius) {
        super(new Pen(), brush, x, y, width, height, arcWidth, arcHeight);
        this.gradientRadius = gradientRadius;
        this.side = 3;
    }

    public void setSide(int side) {
        this.side = side;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rect = (Rectangle)super.getBounds().clone();
        if ((double)this.gradientRadius > 0.0) {
            rect.grow((int)this.gradientRadius, (int)this.gradientRadius);
        }
        return rect;
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.isVisible() && this.brush != null) {
            try {
                Color[] colors;
                float[] fractions;
                Rectangle2D r = this.shape.getBounds2D();
                Color c0 = this.brush.getColor();
                Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), 0);
                double x0 = r.getMinX();
                double y0 = r.getMinY();
                double x1 = r.getMaxX();
                double y1 = r.getMaxY();
                double w = r.getWidth();
                double h = r.getHeight();
                g2.setPaint(c0);
                g2.fill(new Rectangle2D.Double(x0, y0, w, h));
                g2.setPaint(new GradientPaint(new Point2D.Double(x0, y0), c0, new Point2D.Double(x0, y0 - (double)this.gradientRadius), c1));
                g2.fill(new Rectangle2D.Double(x0, y0 - (double)this.gradientRadius, w, this.gradientRadius));
                g2.setPaint(new GradientPaint(new Point2D.Double(x0, y1), c0, new Point2D.Double(x0, y1 + (double)this.gradientRadius), c1));
                g2.fill(new Rectangle2D.Double(x0, y1, w, this.gradientRadius));
                if ((this.side & 2) == 2) {
                    fractions = new float[]{0.0f, 1.0f};
                    colors = new Color[]{c0, c1};
                    g2.setPaint(new GradientPaint(new Point2D.Double(x0, y0), c0, new Point2D.Double(x0 - (double)this.gradientRadius, y0), c1));
                    g2.fill(new Rectangle2D.Double(x0 - (double)this.gradientRadius, y0, this.gradientRadius, h));
                    g2.setPaint(new RadialGradientPaint(new Rectangle2D.Double(x0 - (double)this.gradientRadius, y0 - (double)this.gradientRadius, this.gradientRadius + this.gradientRadius, this.gradientRadius + this.gradientRadius), fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                    g2.fill(new Rectangle2D.Double(x0 - (double)this.gradientRadius, y0 - (double)this.gradientRadius, this.gradientRadius, this.gradientRadius));
                    g2.setPaint(new RadialGradientPaint(new Rectangle2D.Double(x0 - (double)this.gradientRadius, y1 - (double)this.gradientRadius, this.gradientRadius + this.gradientRadius, this.gradientRadius + this.gradientRadius), fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                    g2.fill(new Rectangle2D.Double(x0 - (double)this.gradientRadius, y1, this.gradientRadius, this.gradientRadius));
                }
                if ((this.side & 1) == 1) {
                    g2.setPaint(new GradientPaint(new Point2D.Double(x1, y0), c0, new Point2D.Double(x1 + (double)this.gradientRadius, y0), c1));
                    g2.fill(new Rectangle2D.Double(x1, y0, this.gradientRadius, h));
                    fractions = new float[]{0.0f, 1.0f};
                    colors = new Color[]{c0, c1};
                    g2.setPaint(new RadialGradientPaint(new Rectangle2D.Double(x1 - (double)this.gradientRadius, y0 - (double)this.gradientRadius, this.gradientRadius + this.gradientRadius, this.gradientRadius + this.gradientRadius), fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                    g2.fill(new Rectangle2D.Double(x1, y0 - (double)this.gradientRadius, this.gradientRadius, this.gradientRadius));
                    g2.setPaint(new RadialGradientPaint(new Rectangle2D.Double(x1 - (double)this.gradientRadius, y1 - (double)this.gradientRadius, this.gradientRadius + this.gradientRadius, this.gradientRadius + this.gradientRadius), fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                    g2.fill(new Rectangle2D.Double(x1, y1, this.gradientRadius, this.gradientRadius));
                }
            }
            catch (Throwable t) {
                g2.setColor(Color.RED);
                g2.setStroke(new BasicStroke(3.0f));
                g2.draw(this.shape);
            }
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        result.put("gradientRadius", (double)this.gradientRadius);
        result.put("side", this.side);
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        if (from.has("gradientRadius")) {
            this.gradientRadius = (float)from.getDouble("gradientRadius");
        }
        this.side = from.has("side") ? from.getInt("side") : 3;
    }
}

