/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.DummyView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.ShapeView;
import ru.biosoft.graphics.View;

public class CompositeView
extends View
implements Iterable<View> {
    protected Rectangle rect = new Rectangle(0, 0, 0, 0);
    protected Vector<View> children = new Vector();
    public static final int REL = 8;
    public static final int X_UN = 8;
    public static final int X_RL = 9;
    public static final int X_RC = 10;
    public static final int X_RR = 11;
    public static final int X_LL = 12;
    public static final int X_LC = 13;
    public static final int X_LR = 14;
    public static final int X_CC = 15;
    public static final int Y_UN = 8;
    public static final int Y_TT = 24;
    public static final int Y_TC = 40;
    public static final int Y_TB = 56;
    public static final int Y_BT = 72;
    public static final int Y_BC = 88;
    public static final int Y_BB = 104;
    public static final int Y_CC = 120;
    private Rectangle curRect = null;
    public static final int DELTA = 3;

    public CompositeView() {
        super(null);
    }

    public CompositeView(JSONObject jsonObj) {
        super(null);
        this.initFromJSON(jsonObj);
    }

    @Override
    public void scale(double sx, double sy) {
        for (View v : this.children) {
            v.scale(sx, sy);
        }
        this.at.scale(sx, sy);
    }

    @Override
    public void move(int x, int y) {
        for (View v : this.children) {
            v.move(x, y);
        }
        this.rect.translate(x, y);
    }

    @Override
    public void updateBounds() {
        if (this.children.size() == 0) {
            this.rect = new Rectangle(0, 0, 0, 0);
        } else {
            this.rect = null;
            for (View view : this.children) {
                if (view instanceof CompositeView) {
                    ((CompositeView)view).updateBounds();
                }
                if (this.rect == null) {
                    this.rect = (Rectangle)view.getBounds().clone();
                    continue;
                }
                this.rect.add(view.getBounds());
            }
        }
    }

    public View elementAt(int index) {
        return this.children.elementAt(index);
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<View> iterator() {
        return this.children.iterator();
    }

    public void insert(View v, int i) throws ArrayIndexOutOfBoundsException {
        if (this.children.size() == 0) {
            this.rect = (Rectangle)v.getBounds().clone();
        } else {
            this.rect.add(v.getBounds());
        }
        this.children.insertElementAt(v, i);
    }

    public void add(View v, int mode) {
        this.add(v, mode, new Point(0, 0));
    }

    public void add(View v, int mode, Point insets) {
        Rectangle r = v.getBounds();
        Rectangle rect = this.getBounds();
        int right = rect.x + rect.width;
        int bottom = rect.y + rect.height;
        if (insets == null) {
            insets = new Point(0, 0);
        }
        int x = 0;
        int y = 0;
        if ((mode & 8) == 0) {
            x = r.x;
            y = r.y;
        } else {
            switch (mode & 0xF) {
                case 9: {
                    x = right + insets.x;
                    break;
                }
                case 10: {
                    x = right - r.width / 2 + insets.x;
                    break;
                }
                case 11: {
                    x = right - r.width - insets.x;
                    break;
                }
                case 12: {
                    x = rect.x + insets.x;
                    break;
                }
                case 13: {
                    x = rect.x - r.width / 2 + insets.x;
                    break;
                }
                case 14: {
                    x = rect.x - r.width - insets.x;
                    break;
                }
                case 15: {
                    x = rect.x + rect.width / 2 - r.width / 2 + insets.x;
                    break;
                }
                default: {
                    x = r.x + insets.x;
                }
            }
            switch (mode & 0x78) {
                case 72: {
                    y = bottom + insets.y;
                    break;
                }
                case 88: {
                    y = bottom - r.height / 2 + insets.y;
                    break;
                }
                case 104: {
                    y = bottom - r.height - insets.y;
                    break;
                }
                case 24: {
                    y = rect.y + insets.y;
                    break;
                }
                case 40: {
                    y = rect.y - r.height / 2 + insets.y;
                    break;
                }
                case 56: {
                    y = rect.y - r.height - insets.y;
                    break;
                }
                case 120: {
                    y = rect.y + rect.height / 2 - r.height / 2 + insets.y;
                    break;
                }
                default: {
                    y = r.y + insets.y;
                }
            }
        }
        v.setLocation(x, y);
        this.add(v);
    }

    protected boolean recursiveRemove(View v) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.elementAt(i) == v) {
                this.children.remove(i);
                return true;
            }
            if (!(this.children.elementAt(i) instanceof CompositeView) || !((CompositeView)this.children.elementAt(i)).recursiveRemove(v)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(View v) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.elementAt(i) != v) continue;
            this.children.remove(i);
            return true;
        }
        return this.recursiveRemove(v);
    }

    public void add(View v) {
        if (this.children.size() == 0) {
            this.rect = (Rectangle)v.getBounds().clone();
        } else {
            this.rect.add(v.getBounds());
        }
        this.children.addElement(v);
    }

    @Override
    public Rectangle getBounds() {
        return this.rect.getBounds();
    }

    @Override
    public boolean intersects(Rectangle rect) {
        if (this.isVisible() && this.rect.intersects(rect)) {
            for (View v : this.children) {
                if (!v.intersects(rect)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSelectionPriority(Rectangle rect) {
        int result = 0;
        for (View v : this.children) {
            int priority = v.getSelectionPriority(rect);
            if (priority <= result) continue;
            result = priority;
        }
        return result;
    }

    private View traceFor(CompositeView cv, Object[] ignoreModels, Class<?> modelClass, View maxView) {
        ArrayList<View> selectedViews = new ArrayList<View>();
        for (int i = cv.size() - 1; i >= 0; --i) {
            View childView;
            View v = cv.elementAt(i);
            View curMaxView = maxView;
            if (v.isActive()) {
                Rectangle bounds = v.getBounds();
                if (v.intersects(this.curRect) && (maxView == null || maxView.getBounds().contains(bounds)) && (modelClass == null || modelClass.isInstance(v.getModel()))) {
                    boolean setUp = true;
                    if (ignoreModels != null) {
                        for (Object ignoreModel : ignoreModels) {
                            if (ignoreModel != v.getModel()) continue;
                            setUp = false;
                            break;
                        }
                    }
                    if (setUp) {
                        curMaxView = v;
                    }
                }
            }
            if (v instanceof CompositeView && (childView = this.traceFor((CompositeView)v, ignoreModels, modelClass, curMaxView)) != null) {
                curMaxView = childView;
            }
            if (curMaxView == null || curMaxView == maxView) continue;
            selectedViews.add(curMaxView);
        }
        if (selectedViews.size() == 0) {
            return maxView;
        }
        View result = (View)selectedViews.get(0);
        int maxPriority = result.getSelectionPriority(this.curRect);
        Rectangle bounds = result.getBounds();
        int record = bounds.width * bounds.height;
        for (int i = 1; i < selectedViews.size(); ++i) {
            View v = (View)selectedViews.get(i);
            int priority = v.getSelectionPriority(this.curRect);
            bounds = v.getBounds();
            if (priority > maxPriority) {
                maxPriority = priority;
                record = bounds.width * bounds.height;
                result = v;
                continue;
            }
            if (priority != maxPriority || bounds.width * bounds.height >= record) continue;
            record = bounds.width * bounds.height;
            result = v;
        }
        return result;
    }

    public View getDeepestActive(Point pt) {
        return this.getDeepestActive(pt, null, null);
    }

    public void setPen(Pen pen) {
        for (View child : this) {
            if (child instanceof ShapeView) {
                ((ShapeView)child).setPen(pen);
                continue;
            }
            if (!(child instanceof CompositeView)) continue;
            ((CompositeView)child).setPen(pen);
        }
    }

    public void setBrush(Brush brush) {
        for (View child : this) {
            if (child instanceof ShapeView) {
                ((ShapeView)child).setBrush(brush);
                continue;
            }
            if (!(child instanceof CompositeView)) continue;
            ((CompositeView)child).setBrush(brush);
        }
    }

    public View getDeepestActive(Point pt, Object[] ignoreModels, Class<?> modelClass) {
        this.curRect = new Rectangle(pt.x - 3, pt.y - 3, 6, 6);
        CompositeView maxView = null;
        if (this.isActive()) {
            maxView = this;
        }
        return this.traceFor(this, ignoreModels, modelClass, maxView);
    }

    public Point getLocation() {
        return this.rect.getLocation();
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle rect;
        Rectangle clip = g.getClipBounds();
        if (clip != null && !(rect = this.getBounds()).intersects(clip)) {
            return;
        }
        if (this.isVisible()) {
            for (View v : this.children) {
                v.paint(g);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CompositeView)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompositeView v = (CompositeView)obj;
        if (this.children.size() != v.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equals(v.children.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        View[] childrenArray;
        JSONObject result = super.toJSON();
        JSONArray childArray = new JSONArray();
        for (View childView : childrenArray = this.children.toArray(new View[this.children.size()])) {
            if (!childView.isVisible()) continue;
            childArray.put((Object)childView.toJSON());
        }
        result.put("children", (Object)childArray);
        return result;
    }

    @Override
    public JSONObject toJSONIfChanged(View v) throws JSONException {
        View[] childrenArray;
        if (this.equals(v)) {
            return new DummyView(this.model, this.isActive()).toJSON();
        }
        if (!(v instanceof CompositeView)) {
            return this.toJSON();
        }
        JSONObject result = super.toJSON();
        CompositeView cv = (CompositeView)v;
        int start = 0;
        int length = cv.children.size();
        if (length == 0) {
            return this.toJSON();
        }
        JSONArray childArray = new JSONArray();
        for (View childView : childrenArray = this.children.toArray(new View[this.children.size()])) {
            if (!childView.isVisible()) continue;
            Object newModel = childView.getModel();
            if (newModel == null) {
                childArray.put((Object)childView.toJSON());
                continue;
            }
            boolean found = false;
            int i = start;
            do {
                Object oldModel;
                View oldChildView;
                if (!(oldChildView = cv.children.get(i)).isVisible() || (oldModel = oldChildView.getModel()) == null || newModel != oldModel) continue;
                childArray.put((Object)childView.toJSONIfChanged(oldChildView));
                start = (i + 1) % length;
                found = true;
                break;
            } while ((i = (i + 1) % length) != start);
            if (found) continue;
            childArray.put((Object)childView.toJSON());
        }
        result.put("children", (Object)childArray);
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        try {
            JSONArray childArray = from.getJSONArray("children");
            for (int i = 0; i < childArray.length(); ++i) {
                JSONObject childObj = childArray.getJSONObject(i);
                View child = CompositeView.fromJSON(childObj);
                if (child == null) continue;
                this.add(child);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

