/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Entity;
import javax.swing.text.html.parser.ParserDelegator;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.font.ColorFont;

public class ComplexTextView
extends CompositeView {
    public static final int TEXT_ALIGN_LEFT = 12;
    public static final int TEXT_ALIGN_CENTER = 15;
    public static final int TEXT_ALIGN_RIGHT = 11;
    public static final String BOLD_TAG = "b";
    public static final String ITALIC_TAG = "i";
    public static final String BR_TAG = "br";
    public static final String FONT_TAG = "font";
    public static final String COLOR_ATTR = "color";
    public static final String SIZE_ATTR = "size";
    public static final String SUB_TAG = "sub";
    public static final String SUP_TAG = "sup";
    public static final String ALPHA_TAG = "alpha";
    public static final String BETA_TAG = "beta";
    public static final String GAMMA_TAG = "gamma";
    public static final String DELTA_TAG = "delta";
    private static DTD dtd;
    private static final char[] splitters;

    public ComplexTextView(String text, ColorFont fontNormal, Map<String, ColorFont> fontRegistry, int textAlignment, Graphics graphics, int maxPixelWidth) {
        int stringWidth = graphics.getFontMetrics(fontNormal.getFont()).stringWidth(text);
        int maxStringlength = stringWidth <= maxPixelWidth + 2 ? text.length() : Math.max(4, maxPixelWidth * text.length() / stringWidth - 2);
        this.parse(text, new Point(0, 0), 0, fontNormal, fontRegistry, textAlignment, maxStringlength, graphics);
    }

    public ComplexTextView(String text, ColorFont fontNormal, Map<String, ColorFont> fontRegistry, int textAlignment, int maxStringlength, Graphics graphics) {
        this(text, new Point(0, 0), 0, fontNormal, fontRegistry, textAlignment, maxStringlength, graphics);
    }

    public ComplexTextView(String text, Point pt, int alignment, ColorFont fontNormal, Map<String, ColorFont> fontRegistry, int textAlignment, int maxStringlength, Graphics graphics) {
        this.parse(text, pt, alignment, fontNormal, fontRegistry, textAlignment, maxStringlength, graphics);
    }

    public static String[] split(String string, char delimiter) {
        int n = 1;
        int i = 0;
        while ((i = string.indexOf(delimiter, i)) != -1) {
            ++n;
            ++i;
        }
        if (n == 1) {
            return new String[]{string};
        }
        String[] result = new String[n];
        n = 0;
        i = 0;
        int start = 0;
        while ((i = string.indexOf(delimiter, start)) != -1) {
            result[n++] = string.substring(start, i);
            start = i + 1;
        }
        result[n] = string.substring(start);
        return result;
    }

    public static String convertEntity(String entity) {
        if (entity.startsWith("#")) {
            try {
                int code = entity.startsWith("#x") ? Integer.parseInt(entity.substring(2), 16) : Integer.parseInt(entity.substring(1));
                return new String(new int[]{code}, 0, 1);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        Entity entityValue = dtd.getEntity(entity);
        if (entityValue != null) {
            return entityValue.getString();
        }
        return null;
    }

    protected static Map<String, String> getTagAttributes(String tag) {
        String[] parts;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : parts = ComplexTextView.split(tag, ' ')) {
            if (!part.contains("=")) continue;
            String[] obj = ComplexTextView.split(part, '=');
            String key = obj[0].toLowerCase();
            String value = obj[1].toLowerCase();
            if (value.matches("'.*'") || value.matches("\".*\"")) {
                value = value.substring(1, value.length() - 1);
            }
            result.put(key, value);
        }
        return result;
    }

    protected void processTag(String tag, Map<String, ColorFont> fontRegistry, List<ColorFont> fontStack, ParseState parseState, Graphics graphics) {
        if (tag.equals(BOLD_TAG)) {
            ColorFont font = ComplexTextView.getFont(fontRegistry, fontStack.get(fontStack.size() - 1), BOLD_TAG);
            fontStack.add(font);
        } else if (tag.equals(ITALIC_TAG)) {
            ColorFont font = ComplexTextView.getFont(fontRegistry, fontStack.get(fontStack.size() - 1), ITALIC_TAG);
            fontStack.add(font);
        } else if (tag.equals(BR_TAG)) {
            this.changeLine(parseState);
        } else if (tag.startsWith(FONT_TAG)) {
            ColorFont font = ComplexTextView.getFont(fontRegistry, fontStack.get(fontStack.size() - 1), tag);
            fontStack.add(font);
        } else if (tag.equals("/b") || tag.equals("/i") || tag.startsWith("/font")) {
            if (fontStack.size() > 1) {
                fontStack.remove(fontStack.size() - 1);
            }
        } else if (tag.equals(SUB_TAG)) {
            ColorFont font = ComplexTextView.getFont(fontRegistry, fontStack.get(fontStack.size() - 1), SUB_TAG);
            fontStack.add(font);
            parseState.verticalOffset += font.getFont().getSize() / 2;
        } else if (tag.equals("/sub")) {
            if (fontStack.size() > 1) {
                ColorFont font = fontStack.remove(fontStack.size() - 1);
                parseState.verticalOffset -= font.getFont().getSize() / 2;
            }
        } else if (tag.equals(SUP_TAG)) {
            ColorFont font = ComplexTextView.getFont(fontRegistry, fontStack.get(fontStack.size() - 1), SUB_TAG);
            fontStack.add(font);
            parseState.verticalOffset -= font.getFont().getSize() / 2;
        } else if (tag.equals("/sup")) {
            if (fontStack.size() > 1) {
                ColorFont font = fontStack.remove(fontStack.size() - 1);
                parseState.verticalOffset += font.getFont().getSize() / 2;
            }
        } else if (tag.equals("alpha/")) {
            parseState.buffer.append('\u03b1');
        } else if (tag.equals("beta/")) {
            parseState.buffer.append('\u03b2');
        } else if (tag.equals("gamma/")) {
            parseState.buffer.append('\u03b3');
        } else if (tag.equals("delta/")) {
            parseState.buffer.append('\u03b4');
        } else {
            this.processText(tag, fontStack, parseState, graphics);
        }
    }

    public static ColorFont getFont(Map<String, ColorFont> fontRegistry, ColorFont previous, String tag) {
        int size = previous.getFont().getSize();
        int style = previous.getFont().getStyle();
        String fontName = previous.getFont().getName();
        Color color = previous.getColor();
        if (tag.equals(BOLD_TAG)) {
            style |= 1;
        } else if (tag.equals(ITALIC_TAG)) {
            style |= 2;
        } else if (tag.equals(SUB_TAG) || tag.equals(SUP_TAG)) {
            size -= 2;
        } else if (tag.startsWith(FONT_TAG)) {
            Map<String, String> attr = ComplexTextView.getTagAttributes(tag);
            if (attr.containsKey(SIZE_ATTR)) {
                try {
                    size = Integer.parseInt(attr.get(SIZE_ATTR).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (attr.containsKey(COLOR_ATTR)) {
                String colorName = attr.get(COLOR_ATTR).trim().toUpperCase();
                try {
                    Field colorField = Color.class.getDeclaredField(colorName);
                    if (null != colorField) {
                        color = (Color)colorField.get(null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        String key = size + ":" + style + ":" + color.getRGB();
        if (fontRegistry.containsKey(key)) {
            return fontRegistry.get(key);
        }
        ColorFont font = new ColorFont(fontName, style, size, color);
        fontRegistry.put(key, font);
        return font;
    }

    protected void parse(String text, Point pt, int alignment, ColorFont fontNormal, Map<String, ColorFont> fontRegistry, int textAlignment, int maxStringLength, Graphics graphics) {
        boolean readTag = false;
        boolean readCharacterEntity = false;
        ParseState parseState = new ParseState(pt, maxStringLength, alignment, textAlignment);
        ArrayList<ColorFont> fontStack = new ArrayList<ColorFont>();
        fontStack.add(fontNormal);
        for (int i = 0; i < text.length(); ++i) {
            char currentSymbol = text.charAt(i);
            if (currentSymbol == '&' && !readCharacterEntity) {
                if (parseState.buffer.length() > 0) {
                    this.processText(parseState.buffer.toString(), fontStack, parseState, graphics);
                }
                parseState.buffer = new StringBuffer();
                readCharacterEntity = true;
                continue;
            }
            if (currentSymbol == ';' && readCharacterEntity) {
                String entity = parseState.buffer.toString();
                String entityValue = ComplexTextView.convertEntity(entity);
                parseState.buffer = entityValue != null ? new StringBuffer(entityValue) : new StringBuffer("&" + entity + ";");
                this.processText(parseState.buffer.toString(), fontStack, parseState, graphics);
                parseState.buffer = new StringBuffer();
                readCharacterEntity = false;
                continue;
            }
            if (currentSymbol == '<' && !readTag) {
                if (parseState.buffer.length() > 0) {
                    this.processText(parseState.buffer.toString(), fontStack, parseState, graphics);
                }
                parseState.buffer = new StringBuffer();
                readTag = true;
                continue;
            }
            if (currentSymbol == '>' && readTag) {
                String tag = parseState.buffer.toString().toLowerCase();
                parseState.buffer = new StringBuffer();
                if (tag.length() > 0) {
                    this.processTag(tag, fontRegistry, fontStack, parseState, graphics);
                }
                readTag = false;
                continue;
            }
            parseState.buffer.append(currentSymbol);
        }
        if (parseState.buffer.length() > 0) {
            this.processText(parseState.buffer.toString(), fontStack, parseState, graphics);
        }
        this.add(parseState.currentLine, parseState.textAlignment | 0x48, parseState.offset);
    }

    protected void changeLine(ParseState parseState) {
        this.add(parseState.currentLine, parseState.textAlignment | 0x48, parseState.offset);
        parseState.offset.y = 0;
        parseState.offset.x = 0;
        parseState.currentLine = new CompositeView();
        parseState.currentLineSize = 0;
    }

    protected void processText(String text, List<ColorFont> fontStack, ParseState parseState, Graphics graphics) {
        String part = text;
        while (parseState.currentLineSize + part.length() > parseState.maxStringLength) {
            TextView textView;
            ColorFont font;
            int pos = -1;
            int tmp = -1;
            while ((tmp = this.indexOfSplitter(part, tmp + 1)) != -1 && parseState.currentLineSize + tmp <= parseState.maxStringLength) {
                pos = tmp;
            }
            if (pos <= 0) {
                if (parseState.currentLineSize == 0) {
                    font = fontStack.get(fontStack.size() - 1);
                    textView = new TextView(part.substring(0, parseState.maxStringLength), new Point(0, 0), parseState.alignment, font, graphics);
                    parseState.currentLine.add(textView, 9, new Point(0, parseState.verticalOffset));
                    part = part.substring(parseState.maxStringLength);
                }
            } else if (pos > 0) {
                font = fontStack.get(fontStack.size() - 1);
                textView = new TextView(part.substring(0, pos), new Point(0, 0), parseState.alignment, font, graphics);
                parseState.currentLine.add(textView, 9, new Point(0, parseState.verticalOffset));
                part = part.substring(pos);
            }
            this.changeLine(parseState);
            for (pos = 0; pos < part.length() && part.charAt(pos) == ' '; ++pos) {
            }
            part = part.substring(pos);
        }
        if (part.length() > 0) {
            ColorFont font = fontStack.get(fontStack.size() - 1);
            TextView textView = new TextView(part, new Point(0, 0), parseState.alignment, font, graphics);
            parseState.currentLine.add(textView, 9, new Point(0, parseState.verticalOffset));
            parseState.currentLineSize += part.length();
        }
    }

    protected int indexOfSplitter(String string, int startPos) {
        int result = -1;
        for (char splitter : splitters) {
            int pos = string.indexOf(splitter, startPos);
            if (pos == -1 || result != -1 && pos >= result) continue;
            result = pos;
        }
        return result;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        return result;
    }

    static {
        try {
            new ParserDelegator();
            dtd = DTD.getDTD("html32");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        splitters = new char[]{' ', '-'};
    }

    protected static class ParseState {
        public StringBuffer buffer = new StringBuffer();
        public Point offset;
        public CompositeView currentLine;
        public int currentLineSize;
        public int maxStringLength;
        public int verticalOffset;
        public int alignment;
        public int textAlignment;

        public ParseState(Point pt, int maxStringLength, int alignment, int textAlignment) {
            this.offset = pt;
            this.currentLine = new CompositeView();
            this.currentLineSize = 0;
            this.maxStringLength = Math.max(maxStringLength, 1);
            this.verticalOffset = 0;
            this.alignment = alignment;
            this.textAlignment = textAlignment;
        }
    }
}

