/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Brush {
    private float angle;
    private transient double sin;
    private transient double cos;
    protected Paint paint;
    JSONObject json = null;
    protected PropertyChangeSupport pcSupport = null;

    public Brush() {
        this.paint = Color.BLACK;
    }

    public Brush(Paint color) {
        this.setPaint(color);
    }

    public Brush(JSONObject jsonObj) {
        this.initFromJSON(jsonObj);
    }

    public Brush(Color color1, Color color2, float angle) {
        this.angle = (float)((double)angle * Math.PI / 180.0);
        this.sin = Math.sin(this.angle);
        this.cos = Math.cos(this.angle);
        this.paint = new GradientPaint(0.0f, 0.0f, color1, (float)(100.0 * this.sin), (float)(100.0 * this.cos), color2);
    }

    public Brush(Color color1, Color color2) {
        this(color1, color2, 0.0f);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.angle);
        result = 31 * result + (this.paint == null ? 0 : this.paint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Brush other = (Brush)obj;
        if (Float.floatToIntBits(this.angle) != Float.floatToIntBits(other.angle)) {
            return false;
        }
        if (this.paint == null) {
            return other.paint == null;
        }
        if (this.paint instanceof GradientPaint && other.paint instanceof GradientPaint) {
            return Brush.gradientEquals((GradientPaint)this.paint, (GradientPaint)other.paint);
        }
        return this.paint.equals(other.paint);
    }

    public static boolean gradientEquals(GradientPaint gp1, GradientPaint gp2) {
        return gp1.getColor1().equals(gp2.getColor1()) && gp1.getColor2().equals(gp2.getColor2()) && gp1.isCyclic() == gp2.isCyclic() && gp1.getPoint1().equals(gp2.getPoint1()) && gp1.getPoint2().equals(gp2.getPoint2());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Paint getPaint(Rectangle bounds) {
        if (this.paint instanceof GradientPaint) {
            double proj = (Math.abs((double)bounds.width * this.sin) + Math.abs((double)bounds.height * this.cos)) / 2.0;
            double sinDist = proj * this.sin;
            double cosDist = proj * this.cos;
            return new GradientPaint((float)(bounds.getCenterX() - sinDist), (float)(bounds.getCenterY() - cosDist), ((GradientPaint)this.paint).getColor1(), (float)(bounds.getCenterX() + sinDist), (float)(bounds.getCenterY() + cosDist), ((GradientPaint)this.paint).getColor2());
        }
        return this.paint;
    }

    public void setPaint(Paint value) {
        this.paint = value;
        if (this.paint instanceof GradientPaint) {
            Point2D p1 = ((GradientPaint)this.paint).getPoint1();
            Point2D p2 = ((GradientPaint)this.paint).getPoint2();
            this.angle = (float)Math.atan2(p2.getX() - p1.getX(), p2.getY() - p1.getY());
            this.sin = Math.sin(this.angle);
            this.cos = Math.cos(this.angle);
        }
        this.json = null;
    }

    public Color getColor() {
        if (this.paint instanceof GradientPaint) {
            return ((GradientPaint)this.paint).getColor1();
        }
        return (Color)this.paint;
    }

    public void setColor(Color color) {
        Paint oldValue = this.paint;
        if (this.paint instanceof GradientPaint) {
            GradientPaint oldPaint = (GradientPaint)this.paint;
            this.paint = new GradientPaint(oldPaint.getPoint1(), color, oldPaint.getPoint2(), oldPaint.getColor2());
        } else {
            this.paint = color;
        }
        this.json = null;
        this.firePropertyChange("paint", oldValue, this.paint);
    }

    public Color getColor2() {
        if (this.paint instanceof GradientPaint) {
            return ((GradientPaint)this.paint).getColor2();
        }
        return (Color)this.paint;
    }

    public void setColor2(Color color) {
        Paint oldValue = this.paint;
        if (this.paint instanceof GradientPaint) {
            GradientPaint oldPaint = (GradientPaint)this.paint;
            this.paint = new GradientPaint(oldPaint.getPoint1(), oldPaint.getColor1(), oldPaint.getPoint2(), color);
        } else {
            this.paint = color;
        }
        this.json = null;
        this.firePropertyChange("paint", oldValue, this.paint);
    }

    public boolean isGradient() {
        return this.paint instanceof GradientPaint;
    }

    public void setGradient(boolean gradient) {
        if (gradient == this.isGradient()) {
            return;
        }
        Paint oldValue = this.paint;
        if (gradient) {
            this.paint = new GradientPaint(0.0f, 0.0f, this.getColor(), 0.0f, 100.0f, this.getColor());
            this.angle = 0.0f;
            this.sin = 0.0;
            this.cos = 1.0;
        } else {
            this.paint = this.getColor();
        }
        this.json = null;
        this.firePropertyChange("paint", oldValue, this.paint);
    }

    public boolean isGradientOptionsHidden() {
        return !this.isGradient();
    }

    public double getAngle() {
        if (this.paint instanceof GradientPaint) {
            return (double)(this.angle * 180.0f) / Math.PI;
        }
        return 0.0;
    }

    public void setAngle(double angle) {
        if (!(this.paint instanceof GradientPaint)) {
            return;
        }
        Paint oldValue = this.paint;
        this.angle = (float)(angle * Math.PI / 180.0);
        this.sin = Math.sin(this.angle);
        this.cos = Math.cos(this.angle);
        this.paint = new GradientPaint(0.0f, 0.0f, this.getColor(), (float)(100.0 * this.sin), (float)(100.0 * this.cos), this.getColor2());
        this.json = null;
        this.firePropertyChange("paint", oldValue, this.paint);
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            Color color1 = null;
            Color color2 = null;
            if (this.paint instanceof Color) {
                color1 = (Color)this.paint;
            } else if (this.paint instanceof GradientPaint) {
                color1 = ((GradientPaint)this.paint).getColor1();
                color2 = ((GradientPaint)this.paint).getColor2();
            } else {
                throw new IllegalArgumentException("Unsupported paint: " + this.paint);
            }
            JSONArray c1 = new JSONArray();
            c1.put(color1.getRed());
            c1.put(color1.getGreen());
            c1.put(color1.getBlue());
            c1.put(color1.getAlpha());
            this.json.put("color", (Object)c1);
            if (color2 != null) {
                JSONArray c2 = new JSONArray();
                c2.put(color2.getRed());
                c2.put(color2.getGreen());
                c2.put(color2.getBlue());
                c2.put(color2.getAlpha());
                this.json.put("color2", (Object)c2);
                if ((double)Math.abs(this.angle) > 1.0E-4) {
                    this.json.put("angle", (double)this.angle);
                }
            }
        }
        return this.json;
    }

    private void initFromJSON(JSONObject from) {
        try {
            JSONArray color2;
            JSONArray color = (JSONArray)from.get("color");
            int red = color.getInt(0);
            int green = color.getInt(1);
            int blue = color.getInt(2);
            int alpha = 255;
            if (color.length() > 3) {
                alpha = color.getInt(3);
            }
            if ((color2 = (JSONArray)from.opt("color2")) == null) {
                this.paint = new Color(red, green, blue, alpha);
            } else {
                int red2 = color2.getInt(0);
                int green2 = color2.getInt(1);
                int blue2 = color2.getInt(2);
                int alpha2 = color2.getInt(3);
                this.angle = (float)from.optDouble("angle", 0.0);
                this.sin = Math.sin(this.angle);
                this.cos = Math.cos(this.angle);
                this.paint = new GradientPaint(0.0f, 0.0f, new Color(red, green, blue, alpha), (float)(100.0 * this.sin), (float)(100.0 * this.cos), new Color(red2, green2, blue2, alpha2));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

