/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.ShapeView;

public class BoxView
extends ShapeView {
    public BoxView(JSONObject jsonObj) {
        super(null);
        this.initFromJSON(jsonObj);
    }

    public BoxView(Pen pen, Brush brush, Rectangle rect) {
        this(pen, brush, rect.x, rect.y, rect.width, rect.height);
    }

    public BoxView(Pen pen, Brush brush, int x, int y, int width, int height) {
        this(pen, brush, (float)x, (float)y, (float)width, (float)height);
    }

    public BoxView(Pen pen, Brush brush, float x, float y, float width, float height) {
        super(new Rectangle2D.Float(width > 0.0f ? x : x + width, height > 0.0f ? y : y + height, width > 0.0f ? width : -width, height > 0.0f ? height : -height), pen, brush);
    }

    public BoxView(Pen pen, Brush brush, float x, float y, float width, float height, float arcWidth, float arcHeight) {
        super(new RoundRectangle2D.Float(width > 0.0f ? x : x + width, height > 0.0f ? y : y + height, width > 0.0f ? width : -width, height > 0.0f ? height : -height, arcWidth, arcHeight), pen, brush);
    }

    public BoxView(Pen pen, Brush brush, RectangularShape shape) {
        super(shape, pen, brush);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rect = (Rectangle)super.getBounds().clone();
        if (this.pen != null) {
            rect.grow((int)(this.pen.getWidth() / 2.0), (int)(this.pen.getWidth() / 2.0));
        }
        return rect;
    }

    @Override
    public void move(int sx, int sy) {
        RectangularShape rect = (RectangularShape)this.shape;
        rect.setFrame(rect.getX() + (double)sx, rect.getY() + (double)sy, rect.getWidth(), rect.getHeight());
    }

    public void resize(int sx, int sy) {
        RectangularShape rect = (RectangularShape)this.shape;
        rect.setFrame(rect.getX(), rect.getY(), rect.getWidth() + (double)sx, rect.getHeight() + (double)sy);
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = super.toJSON();
        Rectangle rect = (Rectangle)super.getBounds().clone();
        if (this.shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRect = (RoundRectangle2D)this.shape;
            result.put("arcWidth", roundRect.getArcWidth());
            result.put("arcHeight", roundRect.getArcHeight());
        }
        if (this.shape instanceof Ellipse2D) {
            result.put("class", (Object)"EllipseView");
            result.put("x", rect.x + rect.width / 2);
            result.put("y", rect.y + rect.height / 2);
        } else {
            result.put("x", rect.x);
            result.put("y", rect.y);
        }
        result.put("width", rect.width);
        result.put("height", rect.height);
        return result;
    }

    @Override
    protected void initFromJSON(JSONObject from) {
        super.initFromJSON(from);
        try {
            int x = from.getInt("x");
            int y = from.getInt("y");
            int width = from.getInt("width");
            int height = from.getInt("height");
            if (from.has("arcWidth") && from.has("arcHeight")) {
                float arcw = (float)from.getDouble("arcWidth");
                float arch = (float)from.getDouble("arcHeight");
                this.shape = new RoundRectangle2D.Float(x, y, width, height, arcw, arch);
            } else {
                this.shape = from.has("class") && from.getString("class").equals("EllipseView") ? new Ellipse2D.Float(x - width / 2, y - width / 2, width, height) : new Rectangle2D.Float(x, y, width, height);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

