/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graphics;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.json.JSONObject;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.PathView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.PolygonView;
import ru.biosoft.graphics.PolylineView;
import ru.biosoft.graphics.SimplePath;

public class ArrowView
extends CompositeView {
    public static final int ARROW_TIP = 1;
    public static final int TRIANGLE_TIP = 2;
    public static final int SIMPLE_TIP = 3;
    public static final int DIAMOND_TIP = 4;
    protected Pen pen = null;
    protected Point start;
    protected Point end;
    protected SimplePath path;
    protected PathView pathView = null;

    public static Tip createTip(Pen pen, Brush brush, int tipType) {
        int w1 = 10;
        int w2 = 15;
        int h = 5;
        Tip tip = null;
        switch (tipType) {
            case 1: {
                tip = ArrowView.createArrowTip(pen, brush, w1, w2, h);
                break;
            }
            case 4: {
                tip = ArrowView.createDiamondTip(pen, brush, w1, w2, h);
                break;
            }
            case 2: {
                tip = ArrowView.createTriangleTip(pen, brush, w2, h);
                break;
            }
            case 3: {
                tip = ArrowView.createSimpleTip(pen, w2, h);
            }
        }
        return tip;
    }

    public static Tip createArrowTip(Pen pen, Brush brush, int w1, int w2, int h) {
        Tip tip = new Tip();
        tip.view = new PolygonView(pen, brush, new int[]{-w1, -w2, 0, -w2}, new int[]{0, h, 0, -h});
        tip.width = w2 - w1;
        return tip;
    }

    public static Tip createTriggerTip(Pen pen, Brush brush, int w, int h) {
        return ArrowView.createTriggerTip(pen, brush, w, h, 2, 2);
    }

    public static Tip createTriggerTip(Pen pen, Brush brush, int w, int h, int w2, int h2) {
        Tip tip = new Tip();
        tip.view = new PolygonView(pen, brush, new int[]{-w, -w, -w, -w + w2, -w + w2, 0, -w + w2, -w + w2, -w, -w}, new int[]{0, -h, 0, 0, -h + h2, 0, h - h2, 0, 0, h});
        tip.width = w;
        return tip;
    }

    public static Tip createTriangleTip(Pen pen, Brush brush, int w, int h) {
        Tip tip = new Tip();
        tip.view = new PolygonView(pen, brush, new int[]{-w, 0, -w}, new int[]{h, 0, -h});
        tip.width = w;
        return tip;
    }

    public static Tip createReverseTriangleTip(Pen pen, Brush brush, int w, int h) {
        Tip tip = new Tip();
        tip.view = new PolygonView(pen, brush, new int[]{-w, 0, 0}, new int[]{0, h, -h});
        tip.width = w;
        return tip;
    }

    public static Tip createSimpleTip(Pen pen, int w, int h) {
        Tip tip = new Tip();
        tip.view = new PolylineView(pen, new int[]{-w, 0, -w}, new int[]{h, 0, -h});
        tip.width = (float)pen.getWidth();
        return tip;
    }

    public static Tip createDiamondTip(Pen pen, Brush brush, int w1, int w2, int h) {
        Tip tip = new Tip();
        tip.view = new PolygonView(pen, brush, new int[]{-w2, -w1, 0, -w1}, new int[]{0, h, 0, -h});
        tip.width = w2 - w1;
        return tip;
    }

    public static Tip createLineTip(Pen pen, Brush brush, int w, int h) {
        Tip tip = new Tip();
        tip.view = new PolygonView(pen, brush, new int[]{-w, -w}, new int[]{h, -h});
        tip.width = 0.0f;
        return tip;
    }

    public static Tip createEllipseTip(Pen pen, Brush brush, int r) {
        Tip tip = new Tip();
        int edgeCount = 16;
        int[] xArray = new int[edgeCount];
        int[] yArray = new int[edgeCount];
        for (int i = 0; i < edgeCount; ++i) {
            xArray[i] = (int)((double)r * Math.cos(Math.PI * 2 * (double)i / (double)edgeCount)) - r;
            yArray[i] = (int)((double)r * Math.sin(Math.PI * 2 * (double)i / (double)edgeCount));
        }
        tip.view = new PolygonView(pen, brush, xArray, yArray);
        tip.width = 2 * r;
        return tip;
    }

    public static void locateTip(Tip tip, double alpha, int x, int y) {
        Polygon pol = (Polygon)tip.view.shape;
        ArrowView.rotate(pol, alpha);
        pol.translate(x, y);
    }

    public static void rotate(Polygon pol, double alpha) {
        for (int i = 0; i < pol.npoints; ++i) {
            int x = pol.xpoints[i];
            int y = pol.ypoints[i];
            double l = Math.sqrt((double)x * (double)x + (double)y * (double)y);
            double b = Math.asin((double)y / l);
            if (x < 0) {
                b = Math.PI - b;
            }
            pol.xpoints[i] = (int)Math.round(l * Math.cos(b += alpha));
            pol.ypoints[i] = (int)Math.round(l * Math.sin(b));
        }
    }

    public ArrowView(Pen pen, Brush brush, Point pt0, Point pt1, int startTip, int endTip) {
        this(pen, brush, pt0.x, pt0.y, pt1.x, pt1.y, startTip, endTip);
    }

    public ArrowView(Pen pen, Point pt0, Point pt1, int startTip, int endTip) {
        this(pen, null, pt0, pt1, startTip, endTip);
    }

    public ArrowView(Pen pen, int x1, int y1, int x2, int y2, int startTip, int endTip) {
        this(pen, null, x1, y1, x2, y2, startTip, endTip);
    }

    public ArrowView(Pen pen, Brush brush, int x1, int y1, int x2, int y2, int startTipType, int endTipType) {
        this(pen, null, x1, y1, x2, y2, ArrowView.createTip(pen, brush, startTipType), ArrowView.createTip(pen, brush, endTipType));
    }

    public ArrowView(Pen pen, Brush brush, int x1, int y1, int x2, int y2, Tip startTip, Tip endTip) {
        this.pen = pen;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double l = Math.sqrt(dx * dx + dy * dy);
        double alpha = Math.asin((double)dy / l);
        if (dx < 0) {
            alpha = Math.PI - alpha;
        }
        Point2D.Float pt1 = new Point2D.Float(x1, y1);
        Point2D.Float pt2 = new Point2D.Float(x2, y2);
        this.add(new LineView(pen, pt1, pt2));
        if (startTip != null) {
            ArrowView.locateTip(startTip, alpha + Math.PI, x1, y1);
            this.add(startTip.view);
        }
        if (endTip != null) {
            ArrowView.locateTip(endTip, alpha, x2, y2);
            this.add(endTip.view);
        }
        this.path = new SimplePath(new Point(x1, y1), new Point(x2, y2));
    }

    public ArrowView(Pen pen, Brush brush, SimplePath path, int startTipType, int endTipType) {
        this(pen, brush, path, ArrowView.createTip(pen, brush, startTipType), ArrowView.createTip(pen, brush, endTipType));
    }

    public ArrowView(Pen pen, Brush brush, SimplePath path, Tip startTip, Tip endTip) {
        if (path.npoints >= 2) {
            double alpha;
            double l;
            int dy;
            int dx;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(path.xpoints[0], path.ypoints[0]);
            for (int i = 1; i < path.npoints; ++i) {
                if (path.pointTypes[i] == 1 && i < path.npoints - 1) {
                    generalPath.quadTo(path.xpoints[i], path.ypoints[i], path.xpoints[i + 1], path.ypoints[i + 1]);
                    ++i;
                    continue;
                }
                if (path.pointTypes[i] == 2 && i < path.npoints - 2) {
                    generalPath.curveTo(path.xpoints[i], path.ypoints[i], path.xpoints[i + 1], path.ypoints[i + 1], path.xpoints[i + 2], path.ypoints[i + 2]);
                    i += 2;
                    continue;
                }
                generalPath.lineTo(path.xpoints[i], path.ypoints[i]);
            }
            this.pathView = new PathView(pen, generalPath);
            this.add(this.pathView);
            if (startTip != null) {
                dx = path.xpoints[1] - path.xpoints[0];
                dy = path.ypoints[1] - path.ypoints[0];
                l = Math.sqrt(dx * dx + dy * dy);
                alpha = Math.asin((double)dy / l);
                if (dx < 0) {
                    alpha = Math.PI - alpha;
                }
                ArrowView.locateTip(startTip, alpha + Math.PI, path.xpoints[0], path.ypoints[0]);
                this.add(startTip.view);
            }
            if (endTip != null) {
                dx = path.xpoints[path.npoints - 1] - path.xpoints[path.npoints - 2];
                dy = path.ypoints[path.npoints - 1] - path.ypoints[path.npoints - 2];
                l = Math.sqrt(dx * dx + dy * dy);
                alpha = Math.asin((double)dy / l);
                if (dx < 0) {
                    alpha = Math.PI - alpha;
                }
                ArrowView.locateTip(endTip, alpha, path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1]);
                this.add(endTip.view);
            }
        }
        this.path = path;
    }

    public ArrowView(JSONObject json) {
        super(json);
    }

    public SimplePath getPath() {
        return this.path;
    }

    public Point getPathOffset() {
        Point viewLocation = this.getLocation();
        Point pathLocation = new Point(this.path.xpoints[0], this.path.ypoints[0]);
        for (int i = 1; i < this.path.npoints; ++i) {
            if (this.path.xpoints[i] < pathLocation.x) {
                pathLocation.x = this.path.xpoints[i];
            }
            if (this.path.ypoints[i] >= pathLocation.y) continue;
            pathLocation.y = this.path.ypoints[i];
        }
        return new Point(viewLocation.x - pathLocation.x, viewLocation.y - pathLocation.y);
    }

    @Override
    public boolean intersects(Rectangle rect) {
        if (this.pathView != null ? this.pathView.intersects(rect) : super.intersects(rect)) {
            return true;
        }
        if (this.path == null || this.path.npoints < 2) {
            return false;
        }
        Point offset = this.getPathOffset();
        Rectangle correctedRect = new Rectangle(rect.x - offset.x, rect.y - offset.y, rect.width, rect.height);
        for (int i = 1; i < this.path.npoints - 1; ++i) {
            if (!correctedRect.contains(this.path.xpoints[i], this.path.ypoints[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSelectionPriority(Rectangle rect) {
        if (this.path == null || this.path.npoints < 2) {
            return 0;
        }
        Point offset = this.getPathOffset();
        Rectangle correctedRect = new Rectangle(rect.x - offset.x, rect.y - offset.y, rect.width, rect.height);
        for (int i = 1; i < this.path.npoints - 1; ++i) {
            if (!correctedRect.contains(this.path.xpoints[i], this.path.ypoints[i])) continue;
            return 1;
        }
        return 0;
    }

    public PathView getPathView() {
        return this.pathView;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArrowView)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArrowView v = (ArrowView)obj;
        if (v.getPath().npoints != this.path.npoints) {
            return false;
        }
        if (!Arrays.equals(v.getPath().xpoints, this.path.xpoints)) {
            return false;
        }
        if (!Arrays.equals(v.getPath().ypoints, this.path.ypoints)) {
            return false;
        }
        return Arrays.equals(v.getPath().pointTypes, this.path.pointTypes);
    }

    public static class Tip {
        public PolygonView view;
        public float width;
    }
}

