/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.perspective;

import com.eclipsesource.json.JsonObject;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.util.TextUtil;

public class Rule {
    private final boolean allow;
    private final String template;
    private final Pattern regExp;

    public Rule(boolean allow, String template) {
        this.allow = allow;
        this.template = template;
        this.regExp = Pattern.compile(TextUtil.wildcardToRegex((String)template));
    }

    protected Rule(IConfigurationElement element) {
        this.allow = this.checkAllowed(element);
        this.template = element.getAttribute("id");
        this.regExp = Pattern.compile(TextUtil.wildcardToRegex((String)this.template));
    }

    private boolean checkAllowed(IConfigurationElement element) {
        if (element.getName().equals("allowWithClass")) {
            try {
                ClassLoading.loadClass((String)element.getAttribute("class"));
                return true;
            }
            catch (LoggedClassNotFoundException e) {
                return false;
            }
        }
        return element.getName().equals("allow");
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isMatched(String id) {
        return this.regExp.matcher(id).matches();
    }

    public JsonObject toJSON() {
        return new JsonObject().add("type", this.allow ? "allow" : "deny").add("template", this.template);
    }
}

