/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.perspective;

import biouml.workbench.DatabaseRenderer;
import biouml.workbench.SearchPane;
import biouml.workbench.perspective.Perspective;
import biouml.workbench.perspective.PerspectiveRegistry;
import biouml.workbench.perspective.PerspectiveSelector;
import biouml.workbench.perspective.RepositoryTabInfo;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.model.ComponentFactory;
import java.awt.Component;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.repository.RepositoryPane;
import ru.biosoft.access.repository.RepositoryRenderer;
import ru.biosoft.access.repository.RepositoryTabs;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentsPane;
import ru.biosoft.gui.EditorsManager;
import ru.biosoft.gui.EditorsTabbedPane;
import ru.biosoft.gui.GUI;

public class PerspectiveUI {
    private static Logger log = Logger.getLogger(PerspectiveUI.class.getName());
    private static Perspective currentPerspective = null;
    public static final String PERSPECTIVE_PREFERENCE = "Perspective";

    public static void initPerspective() {
        PerspectiveUI.initPerspectivePreference();
        PerspectiveUI.setPerspective(PerspectiveUI.getCurrentPerspective());
    }

    public static synchronized void setPerspective(Perspective perspective) {
        if (currentPerspective == perspective) {
            return;
        }
        PerspectiveUI.initRepository(perspective);
        PerspectiveUI.initViewParts(perspective);
        currentPerspective = perspective;
        PerspectiveUI.initToolbar();
    }

    private static void initViewParts(Perspective perspective) {
        EditorsManager manager = (EditorsManager)((EditorsTabbedPane)Application.getApplicationFrame().getPanelManager().getPanel("editor")).getEditorsManager();
        Iterator iterator = manager.getEditors().propertyIterator();
        while (iterator.hasNext()) {
            DynamicProperty property = (DynamicProperty)iterator.next();
            String viewPartId = manager.getViewPartId(property.getName());
            if (viewPartId == null) {
                log.log(Level.SEVERE, "No id for viewPart " + property.getName());
                property.setValue((Object)true);
                continue;
            }
            property.setValue((Object)perspective.isViewPartAvailable(viewPartId));
        }
        ComponentFactory.getModel((Object)manager).propertyChange(new PropertyChangeEvent(manager, "*", null, null));
    }

    private static void initRepository(Perspective perspective) {
        RepositoryTabs tabs = GUI.getManager().getRepositoryTabs();
        tabs.removeAll();
        for (RepositoryTabInfo tabInfo : perspective.getRepositoryTabs()) {
            RepositoryPane pane = tabs.addRepositoryPane(tabInfo.getTitle(), tabInfo.getRootPath().optDataCollection());
            if (!tabInfo.isDatabasesTab() || pane.getTree().getCellRenderer() instanceof DatabaseRenderer) continue;
            SearchPane searchPane = new SearchPane(pane);
            pane.add((Component)searchPane, (Object)"South");
            pane.setCellRenderer((RepositoryRenderer)new DatabaseRenderer(pane));
        }
    }

    private static void initToolbar() {
        Document document = Document.getCurrentDocument();
        if (document != null) {
            DocumentsPane.updateActions((Document)document, (Document)document);
        }
    }

    public static synchronized void initPerspectivePreference() {
        String perspective = Application.getPreferences().getStringValue(PERSPECTIVE_PREFERENCE, PerspectiveRegistry.getDefaultPerspective().toString());
        if (PerspectiveRegistry.getPerspective(perspective) == null) {
            perspective = PerspectiveRegistry.getDefaultPerspective().toString();
        }
        try {
            PropertyDescriptor pd = new PropertyDescriptor(PERSPECTIVE_PREFERENCE, String.class, null, null);
            pd.setPropertyEditorClass(PerspectiveSelector.class);
            Application.getPreferences().add(new DynamicProperty(pd, String.class, perspective){

                public void setValue(Object value) {
                    super.setValue(value);
                    PerspectiveUI.setPerspective(PerspectiveRegistry.getPerspective(value.toString()));
                }
            });
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public static Perspective getCurrentPerspective() {
        Object perspectiveObject = Application.getPreferences().getValue(PERSPECTIVE_PREFERENCE);
        return perspectiveObject instanceof String ? PerspectiveRegistry.getPerspective((String)perspectiveObject) : PerspectiveRegistry.getDefaultPerspective();
    }
}

