/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.perspective;

import biouml.workbench.perspective.Perspective;
import biouml.workbench.perspective.RepositoryTabInfo;
import biouml.workbench.perspective.Rule;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;

public class BioUMLPerspective
implements Perspective {
    private static Logger log = Logger.getLogger(BioUMLPerspective.class.getName());
    private static final String IMPORTERS_ATTR = "importers";
    private static final String EXPORTERS_ATTR = "exporters";
    private static final String VIEWPARTS_ATTR = "viewparts";
    private static final String TAB_ATTR = "tab";
    private static final String REPOSITORY_ATTR = "repository";
    private static final String MESSAGEBUNDLE_ATTR = "messageBundle";
    private static final String PRIORITY_ATTR = "priority";
    private static final String NAME_ATTR = "name";
    private static final String INTRO_ATTR = "intro";
    private static final String ACTIONS_ATTR = "actions";
    private static final String PROJECTSELECTOR_ATTR = "projectSelector";
    private static final String TEMPLATE_ATTR = "template";
    private static final String HIDEDIAGRAMPANEL_ATTR = "hideDiagramPanel";
    private static final String CLOSEONLYONSESSIONEXPIRE_ATTR = "closeOnlyOnSessionExpire";
    private final String title;
    private final List<RepositoryTabInfo> tabInfo = new ArrayList<RepositoryTabInfo>();
    private final List<Rule> viewPartRules = new ArrayList<Rule>();
    private final List<Rule> actionRules = new ArrayList<Rule>();
    private final List<Rule> importerRules = new ArrayList<Rule>();
    private final List<Rule> exporterRules = new ArrayList<Rule>();
    private final Map<String, String> messageBundle = new HashMap<String, String>();
    private int priority;
    private String introPage;
    private boolean showProjectSelector = true;
    private String defaultTemplate = null;
    private boolean hideDiagramPanel = false;
    private boolean closeOnlyOnSessionExpire = false;

    protected BioUMLPerspective(IConfigurationElement element) {
        IConfigurationElement[] rules;
        IConfigurationElement[] exporters;
        IConfigurationElement[] rules2;
        IConfigurationElement[] importers;
        IConfigurationElement[] rules3;
        IConfigurationElement[] actions;
        IConfigurationElement[] rules4;
        IConfigurationElement[] viewParts;
        IConfigurationElement[] messages;
        IConfigurationElement[] messagesArray;
        IConfigurationElement[] tabs;
        IConfigurationElement[] repository;
        this.title = element.getAttribute(NAME_ATTR);
        try {
            this.priority = Integer.parseInt(element.getAttribute(PRIORITY_ATTR));
        }
        catch (Exception e) {
            this.priority = 0;
        }
        if (element.getAttribute(PROJECTSELECTOR_ATTR) != null) {
            this.showProjectSelector = Boolean.parseBoolean(element.getAttribute(PROJECTSELECTOR_ATTR));
        }
        if ((repository = element.getChildren(REPOSITORY_ATTR)) != null && repository.length > 0 && (tabs = repository[0].getChildren(TAB_ATTR)) != null) {
            for (IConfigurationElement tab : tabs) {
                this.tabInfo.add(new RepositoryTabInfo(tab));
            }
        }
        if ((messagesArray = element.getChildren(MESSAGEBUNDLE_ATTR)) != null && messagesArray.length > 0 && (messages = messagesArray[0].getChildren()) != null) {
            for (IConfigurationElement message : messages) {
                this.messageBundle.put(message.getAttribute("key"), message.getAttribute("value"));
            }
        }
        if ((viewParts = element.getChildren(VIEWPARTS_ATTR)) != null && viewParts.length > 0 && (rules4 = viewParts[0].getChildren()) != null) {
            for (IConfigurationElement rule : rules4) {
                this.viewPartRules.add(new Rule(rule));
            }
        }
        if ((actions = element.getChildren(ACTIONS_ATTR)) != null && actions.length > 0 && (rules3 = actions[0].getChildren()) != null) {
            for (IConfigurationElement rule : rules3) {
                this.actionRules.add(new Rule(rule));
            }
        }
        if ((importers = element.getChildren(IMPORTERS_ATTR)) != null && importers.length > 0 && (rules2 = importers[0].getChildren()) != null) {
            for (IConfigurationElement rule : rules2) {
                this.importerRules.add(new Rule(rule));
            }
        }
        if ((exporters = element.getChildren(EXPORTERS_ATTR)) != null && exporters.length > 0 && (rules = exporters[0].getChildren()) != null) {
            for (IConfigurationElement rule : rules) {
                this.exporterRules.add(new Rule(rule));
            }
        }
        try {
            this.introPage = element.getAttribute(INTRO_ATTR);
            this.defaultTemplate = element.getAttribute(TEMPLATE_ATTR);
            this.hideDiagramPanel = Boolean.parseBoolean(element.getAttribute(HIDEDIAGRAMPANEL_ATTR));
            this.closeOnlyOnSessionExpire = Boolean.parseBoolean(element.getAttribute(CLOSEONLYONSESSIONEXPIRE_ATTR));
        }
        catch (Exception e) {
            log.fine("Can not load all perspective attributes for " + this.title);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<RepositoryTabInfo> getRepositoryTabs() {
        return Collections.unmodifiableList(this.tabInfo);
    }

    @Override
    public boolean isViewPartAvailable(String viewPartId) {
        return BioUMLPerspective.matchRules(this.viewPartRules, viewPartId);
    }

    @Override
    public String getIntroPage() {
        return this.introPage;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject result = new JsonObject();
        result.add(NAME_ATTR, this.title);
        result.add(PRIORITY_ATTR, this.priority);
        if (this.introPage != null) {
            result.add(INTRO_ATTR, this.introPage);
        }
        if (this.showProjectSelector) {
            result.add(PROJECTSELECTOR_ATTR, this.showProjectSelector);
        }
        if (this.defaultTemplate != null) {
            result.add(TEMPLATE_ATTR, this.defaultTemplate);
        }
        if (this.hideDiagramPanel) {
            result.add(HIDEDIAGRAMPANEL_ATTR, this.hideDiagramPanel);
        }
        if (this.closeOnlyOnSessionExpire) {
            result.add(CLOSEONLYONSESSIONEXPIRE_ATTR, this.closeOnlyOnSessionExpire);
        }
        if (this.messageBundle.size() > 0) {
            JsonObject bundle = new JsonObject();
            this.messageBundle.forEach((k, v) -> bundle.add(k, v));
            result.add(MESSAGEBUNDLE_ATTR, (JsonValue)bundle);
        }
        JsonArray repository = new JsonArray();
        for (RepositoryTabInfo repositoryTabInfo : this.tabInfo) {
            repository.add((JsonValue)repositoryTabInfo.toJSON());
        }
        result.add(REPOSITORY_ATTR, (JsonValue)repository);
        JsonArray viewParts = new JsonArray();
        for (Rule rule : this.viewPartRules) {
            viewParts.add((JsonValue)rule.toJSON());
        }
        result.add(VIEWPARTS_ATTR, (JsonValue)viewParts);
        JsonArray jsonArray = new JsonArray();
        for (Rule rule : this.actionRules) {
            jsonArray.add((JsonValue)rule.toJSON());
        }
        result.add(ACTIONS_ATTR, (JsonValue)jsonArray);
        return result;
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public boolean isActionAvailable(String actionId) {
        return BioUMLPerspective.matchRules(this.actionRules, actionId);
    }

    @Override
    public boolean isImporterAvailable(String importerId) {
        return BioUMLPerspective.matchRules(this.importerRules, importerId);
    }

    @Override
    public boolean isExporterAvailable(String exporterId) {
        return BioUMLPerspective.matchRules(this.exporterRules, exporterId);
    }

    private static boolean matchRules(List<Rule> rules, String id) {
        boolean result = true;
        for (Rule rule : rules) {
            if (!rule.isMatched(id)) continue;
            result = rule.isAllow();
        }
        return result;
    }

    @Override
    public String getDefaultTemplate() {
        return this.defaultTemplate;
    }
}

