/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml.editor;

import biouml.workbench.diagram.NewDiagramDialog;
import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.XmlModuleType;
import biouml.workbench.module.xml.editor.CommonTab;
import biouml.workbench.module.xml.editor.ExternalTab;
import biouml.workbench.module.xml.editor.NotationsTab;
import biouml.workbench.module.xml.editor.TypesTab;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.access.Repository;
import ru.biosoft.access.core.DataCollection;

public class XmlModuleDialog
extends OkCancelDialog {
    protected static final Logger log = Logger.getLogger(NewDiagramDialog.class.getName());
    public static final String COMMON = "Common";
    public static final String PROPERTIES = "Properties";
    public static final String GRAPHIC_NOTATIONS = "Diagram types";
    public static final String EXTERNAL_DATABASES = "External types";
    public static final String TYPES = "Types";
    protected DataCollection repository = null;
    protected XmlModule module = null;
    protected JTabbedPane tabbedPane;
    protected CommonTab commonTab;
    protected TypesTab typesTab;
    protected ExternalTab externalTab;
    protected NotationsTab notationsTab;

    public XmlModuleDialog(JDialog dialog, String title, DataCollection repository, XmlModule module) {
        super(dialog, title);
        this.init(repository, module);
    }

    public XmlModuleDialog(JFrame frame, String title, DataCollection repository, XmlModule module) {
        super(frame, title);
        this.init(repository, module);
    }

    protected void init(DataCollection repository, XmlModule module) {
        this.module = module;
        this.repository = repository;
        JPanel content = new JPanel(new BorderLayout(5, 5));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.commonTab = new CommonTab(module);
        if (module != null) {
            this.typesTab = new TypesTab(module.getInternalTypes());
            this.externalTab = new ExternalTab(module.getExternalTypes());
            this.notationsTab = new NotationsTab(module.getDiagramTypes());
        } else {
            this.typesTab = new TypesTab(XmlModule.getDefaultInternalTypes());
            this.externalTab = new ExternalTab(null);
            this.notationsTab = new NotationsTab(XmlModule.getDefaultDiagramTypes());
        }
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.add(COMMON, this.commonTab);
        this.tabbedPane.add(TYPES, this.typesTab);
        this.tabbedPane.add(EXTERNAL_DATABASES, this.externalTab);
        this.tabbedPane.add(GRAPHIC_NOTATIONS, this.notationsTab);
        this.add(this.tabbedPane, "Center");
    }

    public XmlModule getModule() {
        return this.module;
    }

    protected void okPressed() {
        if (this.validateForms()) {
            if (this.module == null) {
                String name = this.commonTab.getModuleName();
                Properties primary = new Properties();
                primary.setProperty("name", name);
                primary.setProperty("class", LocalRepository.class.getName());
                String fileName = name + ".xml";
                Properties transformed = new Properties();
                transformed.setProperty("class", XmlModule.class.getName());
                transformed.setProperty("module-type", XmlModuleType.class.getName());
                transformed.setProperty("moduleXml", fileName);
                transformed.setProperty("querySystem", "biouml.plugins.lucene.LuceneQuerySystemImpl");
                transformed.setProperty("data-collection-listener", "biouml.plugins.lucene.LuceneInitListener");
                transformed.setProperty("lucene-directory", "luceneIndex");
                try {
                    this.module = (XmlModule)CollectionFactoryUtils.createDerivedCollection((Repository)((Repository)this.repository), (String)name, (Properties)primary, (Properties)transformed, (String)name);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Can not create module", t);
                }
            }
            this.commonTab.applyChanges(this.module);
            this.typesTab.applyChanges(this.module);
            this.externalTab.applyChanges(this.module);
            this.notationsTab.applyChanges(this.module);
            super.okPressed();
        }
    }

    protected boolean validateForms() {
        String errors = this.commonTab.validateForm();
        if (errors != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), errors, "Incorrect values", 1);
            this.tabbedPane.setSelectedIndex(0);
            return false;
        }
        errors = this.typesTab.validateForm();
        if (errors != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), errors, "Incorrect values", 1);
            this.tabbedPane.setSelectedIndex(1);
            return false;
        }
        errors = this.externalTab.validateForm();
        if (errors != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), errors, "Incorrect values", 1);
            this.tabbedPane.setSelectedIndex(2);
            return false;
        }
        errors = this.notationsTab.validateForm();
        if (errors != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), errors, "Incorrect values", 1);
            this.tabbedPane.setSelectedIndex(3);
            return false;
        }
        return true;
    }
}

