/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml.editor;

import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.editor.MessageBundle;
import biouml.workbench.module.xml.editor.RichTableControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class TypesTab
extends JPanel {
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected List<XmlModule.InternalType> typesList = new ArrayList<XmlModule.InternalType>();
    protected RichTableControl rtControl;

    public TypesTab(List<XmlModule.InternalType> internalTypes) {
        if (internalTypes != null) {
            for (XmlModule.InternalType it : internalTypes) {
                this.typesList.add(it.clone());
            }
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.rtControl = new RichTableControl(this.typesList, XmlModule.InternalType.class, new String[]{"name", "section", "typeClass"});
        this.add((Component)this.rtControl, "Center");
    }

    public String validateForm() {
        StringBuilder result = new StringBuilder("<html>");
        for (XmlModule.InternalType it : this.typesList) {
            if (it.getName() != null && it.getName().length() != 0 && it.getSection() != null && it.getSection().length() != 0 && it.getTypeClass() != null && it.getTypeClass().length() != 0 && it.getTypeTransformer() != null && it.getTypeTransformer().length() != 0) continue;
            result.append(this.messageBundle.getResourceString("TYPES_TAB_VALUES_ERROR")).append("<br>");
            break;
        }
        if (result.length() > 6) {
            return result.toString();
        }
        return null;
    }

    public void applyChanges(XmlModule module) {
        module.setInternalTypes(this.typesList);
    }
}

