/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml.editor;

import biouml.workbench.module.xml.editor.MessageBundle;
import com.developmentontheedge.beans.swing.PropertyInspector;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.swing.table.AbstractRowModel;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnModel;
import com.developmentontheedge.beans.swing.table.ColumnWithSort;
import com.developmentontheedge.beans.swing.table.RowModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RichTableControl
extends JPanel {
    protected Logger log = Logger.getLogger(RichTableControl.class.getName());
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected TabularPropertyInspector table;
    protected PropertyInspector propertyInspector;
    protected JButton addButton;
    protected JButton removeButton;
    protected List objects;
    protected Object activeType;
    protected Class elementType;
    protected ColumnModel columnModel;

    public RichTableControl(List objects, Class elementType, String[] fields) {
        this.objects = objects;
        this.elementType = elementType;
        this.initColumnModel(fields);
        this.setLayout(new GridBagLayout());
        this.table = new TabularPropertyInspector();
        this.table.setPreferredSize(new Dimension(450, 200));
        this.table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RichTableControl.this.selectItem();
            }
        });
        JScrollPane typesScrollPane = new JScrollPane((Component)this.table, 20, 31);
        this.refreshTabularInspector();
        this.add((Component)typesScrollPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addButton = new JButton(this.messageBundle.getResourceString("TAB_ADD_BUTTON"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RichTableControl.this.addAction();
            }
        });
        this.add((Component)this.addButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.removeButton = new JButton(this.messageBundle.getResourceString("TAB_REMOVE_BUTTON"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RichTableControl.this.removeAction();
            }
        });
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.propertyInspector = new PropertyInspector();
        this.propertyInspector.setPreferredSize(new Dimension(450, 150));
        JScrollPane detailsScrollPane = new JScrollPane((Component)this.propertyInspector, 20, 31);
        this.add((Component)detailsScrollPane, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initColumnModel(String[] fields) {
        if (fields != null) {
            Column[] columns = new Column[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String displayName = "";
                try {
                    for (PropertyDescriptor pd : Introspector.getBeanInfo(this.elementType).getPropertyDescriptors()) {
                        if (!pd.getName().equals(fields[i])) continue;
                        displayName = pd.getDisplayName();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                columns[i] = new ColumnWithSort(null, fields[i], displayName);
            }
            this.columnModel = new ColumnModel(columns);
        }
    }

    protected void refreshTabularInspector() {
        if (this.objects == null || this.objects.size() == 0) {
            this.table.explore(new Object[0]);
        } else if (this.columnModel == null) {
            this.table.explore(this.objects.toArray());
        } else {
            this.table.explore((RowModel)new AbstractRowModel(){

                public int size() {
                    return RichTableControl.this.objects.size();
                }

                public Object getBean(int index) {
                    return RichTableControl.this.objects.get(index);
                }
            }, this.columnModel);
        }
    }

    protected void selectItem() {
        Object obj = this.table.getModelOfSelectedRow();
        if (obj != null) {
            this.activeType = obj;
            this.propertyInspector.explore(obj);
            this.propertyInspector.setRootVisible(false);
            this.setEnable((Component)this.propertyInspector, true);
        }
    }

    protected void removeAction() {
        if (this.activeType != null) {
            this.objects.remove(this.activeType);
            this.activeType = null;
            this.setEnable((Component)this.propertyInspector, false);
            this.refreshTabularInspector();
        }
    }

    protected void addAction() {
        try {
            this.activeType = this.elementType.newInstance();
            this.objects.add(this.activeType);
            this.propertyInspector.explore(this.activeType);
            this.propertyInspector.setRootVisible(false);
            this.setEnable((Component)this.propertyInspector, true);
            this.refreshTabularInspector();
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Can not create new element", t);
        }
    }

    private void setEnable(Component component, boolean enable) {
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                c.setEnabled(enable);
                this.setEnable(c, enable);
            }
        }
    }
}

