/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml.editor;

import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.editor.MessageBundle;
import biouml.workbench.module.xml.editor.RichTableControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class NotationsTab
extends JPanel {
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected List<XmlModule.DiagramTypeDescription> dtList = new ArrayList<XmlModule.DiagramTypeDescription>();
    protected RichTableControl rtControl;

    public NotationsTab(List<XmlModule.DiagramTypeDescription> diagramTypes) {
        if (diagramTypes != null) {
            for (XmlModule.DiagramTypeDescription dt : diagramTypes) {
                this.dtList.add(dt.clone());
            }
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.rtControl = new RichTableControl(this.dtList, XmlModule.DiagramTypeDescription.class, null);
        this.add((Component)this.rtControl, "Center");
    }

    public String validateForm() {
        StringBuilder result = new StringBuilder("<html>");
        if (this.dtList.size() == 0) {
            result.append(this.messageBundle.getResourceString("NOTATIONS_TAB_LIST_ERROR")).append("<br>");
        }
        for (XmlModule.DiagramTypeDescription dt : this.dtList) {
            if (dt.getName() == null || dt.getName().length() == 0 || dt.getType() == null || dt.getType().length() == 0) {
                result.append(this.messageBundle.getResourceString("NOTATIONS_TAB_VALUES_ERROR")).append("<br>");
                break;
            }
            if (dt.getType().equals("Java") && (dt.getClassName() == null || dt.getClassName().length() == 0)) {
                result.append(this.messageBundle.getResourceString("NOTATIONS_TAB_CLASS_ERROR")).append("<br>");
                break;
            }
            if (!dt.getType().equals("XML") || dt.getPath() != null && dt.getPath().length() != 0) continue;
            result.append(this.messageBundle.getResourceString("NOTATIONS_TAB_PATH_ERROR")).append("<br>");
            break;
        }
        if (result.length() > 6) {
            return result.toString();
        }
        return null;
    }

    public void applyChanges(XmlModule module) {
        module.setDiagramTypes(this.dtList);
    }
}

