/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml.editor;

import biouml.model.CollectionDescription;
import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.editor.MessageBundle;
import biouml.workbench.module.xml.editor.RichTableControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ExternalTab
extends JPanel {
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected List<CollectionDescription> externalTypesList = new ArrayList<CollectionDescription>();
    protected RichTableControl rtControl;

    public ExternalTab(List<CollectionDescription> externalTypes) {
        if (externalTypes != null) {
            for (CollectionDescription cd : externalTypes) {
                this.externalTypesList.add(cd.clone());
            }
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.rtControl = new RichTableControl(this.externalTypesList, CollectionDescription.class, null);
        this.add((Component)this.rtControl, "Center");
    }

    public String validateForm() {
        StringBuilder result = new StringBuilder("<html>");
        for (CollectionDescription cd : this.externalTypesList) {
            if (cd.getModuleName() != null && cd.getModuleName().length() != 0 && cd.getSectionName() != null && cd.getSectionName().length() != 0) continue;
            result.append(this.messageBundle.getResourceString("EXTERNAL_TAB_VALUES_ERROR")).append("<br>");
            break;
        }
        if (result.length() > 6) {
            return result.toString();
        }
        return null;
    }

    public void applyChanges(XmlModule module) {
        module.setExternalType(this.externalTypesList);
    }
}

