/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml.editor;

import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.editor.MessageBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class CommonTab
extends JPanel {
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected JTextField nameField;
    protected JTextField titleField;
    protected JTextArea description;
    protected JComboBox<String> typeField;
    protected JTextField dbTypeField;
    protected JTextField dbVersionField;
    protected JTextField dbNameField;
    protected JTextField jdbcDriverField;
    protected JTextField jdbcUrlField;
    protected JTextField jdbcUsernameField;
    protected JTextField jdbcPasswordField;
    protected XmlModule module;

    public CommonTab(XmlModule module) {
        this.module = module;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_NAME_FIELD")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.nameField = new JTextField(30);
        if (module != null) {
            this.nameField.setText(module.getName());
            this.nameField.setEnabled(false);
        }
        this.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_TITLE_FIELD")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.titleField = new JTextField(30);
        if (module != null) {
            this.titleField.setText(module.getInfo().getDisplayName());
        }
        this.add((Component)this.titleField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_DESCRIPTION_FIELD")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.description = new JTextArea(3, 30);
        this.description.setLineWrap(true);
        this.add((Component)new JScrollPane(this.description, 20, 31), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_TYPE_FIELD")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.typeField = new JComboBox();
        this.typeField.addItem("text");
        this.typeField.addItem("SQL");
        this.add(this.typeField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.typeField.addItemListener(e -> this.changeType((String)e.getItem()));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_DB_NAME_FIELD")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dbNameField = new JTextField(30);
        this.dbNameField.setEnabled(false);
        this.add((Component)this.dbNameField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_DB_TYPE_FIELD")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dbTypeField = new JTextField(30);
        this.dbTypeField.setEnabled(false);
        this.add((Component)this.dbTypeField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_DB_VERSION_FIELD")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dbVersionField = new JTextField(30);
        this.dbVersionField.setEnabled(false);
        this.add((Component)this.dbVersionField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_JDBC_DRIVER_FIELD")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jdbcDriverField = new JTextField(30);
        this.jdbcDriverField.setEnabled(false);
        this.jdbcDriverField.setText(this.messageBundle.getResourceString("COMMON_TAB_JDBC_DEFAULT_DRIVER"));
        this.add((Component)this.jdbcDriverField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_JDBC_URL_FIELD")), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jdbcUrlField = new JTextField(30);
        this.jdbcUrlField.setEnabled(false);
        this.jdbcUrlField.setText(this.messageBundle.getResourceString("COMMON_TAB_JDBC_DEFAULT_URL"));
        this.add((Component)this.jdbcUrlField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_JDBC_USERNAME_FIELD")), new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jdbcUsernameField = new JTextField(30);
        this.jdbcUsernameField.setEnabled(false);
        this.add((Component)this.jdbcUsernameField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.messageBundle.getResourceString("COMMON_TAB_JDBC_PASSWORD_FIELD")), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jdbcPasswordField = new JTextField(30);
        this.jdbcPasswordField.setEnabled(false);
        this.add((Component)this.jdbcPasswordField, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.setInitValues();
    }

    protected void changeType(String type) {
        if (type.equals("SQL")) {
            this.dbNameField.setEnabled(true);
            this.dbTypeField.setEnabled(true);
            this.dbVersionField.setEnabled(true);
            this.jdbcDriverField.setEnabled(true);
            this.jdbcUrlField.setEnabled(true);
            this.jdbcUsernameField.setEnabled(true);
            this.jdbcPasswordField.setEnabled(true);
        } else {
            this.dbNameField.setEnabled(false);
            this.dbTypeField.setEnabled(false);
            this.dbVersionField.setEnabled(false);
            this.jdbcDriverField.setEnabled(false);
            this.jdbcUrlField.setEnabled(false);
            this.jdbcUsernameField.setEnabled(false);
            this.jdbcPasswordField.setEnabled(false);
        }
    }

    protected void setInitValues() {
        if (this.module != null) {
            this.description.setText(this.module.getDescription());
            Properties dbProperties = this.module.getDatabaseProperties();
            if (dbProperties != null) {
                if (dbProperties.containsKey("databaseType")) {
                    this.dbTypeField.setText(dbProperties.getProperty("databaseType"));
                }
                if (dbProperties.containsKey("databaseName")) {
                    this.dbNameField.setText(dbProperties.getProperty("databaseName"));
                }
                if (dbProperties.containsKey("databaseVersion")) {
                    this.dbVersionField.setText(dbProperties.getProperty("databaseVersion"));
                }
                if (dbProperties.containsKey("jdbcDriverClass")) {
                    this.jdbcDriverField.setText(dbProperties.getProperty("jdbcDriverClass"));
                }
                if (dbProperties.containsKey("jdbcURL")) {
                    this.jdbcUrlField.setText(dbProperties.getProperty("jdbcURL"));
                }
                if (dbProperties.containsKey("jdbcUser")) {
                    this.jdbcUsernameField.setText(dbProperties.getProperty("jdbcUser"));
                }
                if (dbProperties.containsKey("jdbcPassword")) {
                    this.jdbcPasswordField.setText(dbProperties.getProperty("jdbcPassword"));
                }
            }
            this.typeField.setSelectedItem(this.module.getModuleType());
        }
    }

    public String validateForm() {
        String result = "<html>";
        if (this.titleField.getText().trim().length() == 0 || this.nameField.getText().trim().length() == 0) {
            result = result + this.messageBundle.getResourceString("COMMON_TAB_TITLE_ERROR") + "<br>";
        }
        if (this.typeField.getSelectedItem().equals("SQL") && (this.jdbcDriverField.getText().trim().length() == 0 || this.jdbcUrlField.getText().trim().length() == 0)) {
            result = result + this.messageBundle.getResourceString("COMMON_TAB_JDBC_ERROR") + "<br>";
        }
        if (result.length() > 6) {
            return result;
        }
        return null;
    }

    public void applyChanges(XmlModule module) {
        module.getInfo().setDisplayName(this.titleField.getText());
        module.getInfo().setDescription(this.description.getText());
        module.setModuleType((String)this.typeField.getSelectedItem());
        if (this.typeField.getSelectedItem().equals("SQL")) {
            Properties dbProperties = module.getDatabaseProperties();
            dbProperties.put("databaseType", this.dbTypeField.getText());
            dbProperties.put("databaseName", this.dbNameField.getText());
            dbProperties.put("databaseVersion", this.dbVersionField.getText());
            dbProperties.put("jdbcDriverClass", this.jdbcDriverField.getText());
            dbProperties.put("jdbcURL", this.jdbcUrlField.getText());
            dbProperties.put("jdbcUser", this.jdbcUsernameField.getText());
            dbProperties.put("jdbcPassword", this.jdbcPasswordField.getText());
        }
    }

    public String getModuleName() {
        return this.nameField.getText();
    }
}

