/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml;

import biouml.model.CollectionDescription;
import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.XmlModuleSupport;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlModuleWriter
extends XmlModuleSupport {
    protected static final Logger log = Logger.getLogger(XmlModuleWriter.class.getName());
    private Document doc;
    protected OutputStream stream;
    protected XmlModule module;

    public XmlModuleWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void write(XmlModule module) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.write(module, transformerFactory.newTransformer());
    }

    public void write(XmlModule module, Transformer transformer) throws Exception {
        if (module == null) {
            String msg = "XmlModuleWriter - module is null, can not be written.";
            NullPointerException e = new NullPointerException(msg);
            log.log(Level.SEVERE, msg, e);
            throw e;
        }
        this.module = module;
        module.setReadingAvailable(false);
        this.buildDocument();
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.stream);
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        module.setReadingAvailable(true);
    }

    protected Document buildDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.doc.appendChild(this.createDBModuleElement());
        return this.doc;
    }

    protected Element createDBModuleElement() {
        Element element = this.doc.createElement("dbModule");
        element.setAttribute("name", this.module.getName());
        element.setAttribute("title", this.module.getInfo().getDisplayName());
        element.setAttribute("description", this.module.getInfo().getDescription());
        element.setAttribute("version", this.module.getVersion());
        element.setAttribute("type", this.module.getModuleType());
        if (this.module.getModuleType().equals("SQL")) {
            Properties properties = this.module.getDatabaseProperties();
            if (properties.containsKey("databaseType") && properties.getProperty("databaseType").length() > 0) {
                element.setAttribute("databaseType", properties.getProperty("databaseType"));
            }
            if (properties.containsKey("databaseVersion") && properties.getProperty("databaseVersion").length() > 0) {
                element.setAttribute("databaseVersion", properties.getProperty("databaseVersion"));
            }
            if (properties.containsKey("databaseName") && properties.getProperty("databaseName").length() > 0) {
                element.setAttribute("databaseName", properties.getProperty("databaseName"));
            }
            Element dbElement = this.doc.createElement("jdbcConnection");
            if (properties.containsKey("jdbcDriverClass")) {
                dbElement.setAttribute("jdbcDriverClass", properties.getProperty("jdbcDriverClass"));
            }
            if (properties.containsKey("jdbcURL")) {
                dbElement.setAttribute("jdbcURL", properties.getProperty("jdbcURL"));
            }
            if (properties.containsKey("jdbcUser")) {
                dbElement.setAttribute("jdbcUser", properties.getProperty("jdbcUser"));
            }
            if (properties.containsKey("jdbcPassword")) {
                dbElement.setAttribute("jdbcPassword", properties.getProperty("jdbcPassword"));
            }
            element.appendChild(dbElement);
        }
        this.createDependenciesElement(element);
        this.createTypesElement(element);
        return element;
    }

    protected void createDependenciesElement(Element element) {
        Element dElement = this.doc.createElement("dependencies");
        if (this.module.getExternalTypes() != null) {
            this.createExternalModulesElement(dElement);
        }
        if (this.module.getDiagramTypes() != null) {
            for (XmlModule.DiagramTypeDescription dt : this.module.getDiagramTypes()) {
                this.createDiagramTypeElement(dElement, dt);
            }
        }
        element.appendChild(dElement);
    }

    protected void createExternalModulesElement(Element element) {
        ArrayList<String> processedModules = new ArrayList<String>();
        while (true) {
            String moduleName = null;
            for (CollectionDescription cd : this.module.getExternalTypes()) {
                if (processedModules.contains(cd.getModuleName())) continue;
                moduleName = cd.getModuleName();
                break;
            }
            if (moduleName == null) break;
            processedModules.add(moduleName);
            Element externalModule = this.doc.createElement("externalModule");
            externalModule.setAttribute("name", moduleName);
            for (CollectionDescription cd : this.module.getExternalTypes()) {
                if (!cd.getModuleName().equals(moduleName)) continue;
                this.creatExternalTypeElement(externalModule, cd);
            }
            element.appendChild(externalModule);
        }
    }

    protected void creatExternalTypeElement(Element element, CollectionDescription cd) {
        Element etElement = this.doc.createElement("externalType");
        etElement.setAttribute("name", cd.getTypeName());
        etElement.setAttribute("section", cd.getSectionName());
        String type = "true";
        if (!cd.isReadOnly()) {
            type = "false";
        }
        etElement.setAttribute("readOnly", type);
        element.appendChild(etElement);
    }

    protected void createDiagramTypeElement(Element element, XmlModule.DiagramTypeDescription dt) {
        Element dtElement = this.doc.createElement("graphicNotation");
        dtElement.setAttribute("name", dt.getName());
        dtElement.setAttribute("type", dt.getType());
        if (dt.getClassName() != null && dt.getClassName().length() > 0) {
            dtElement.setAttribute("class", dt.getClassName());
        }
        if (dt.getPath() != null && dt.getPath().length() > 0) {
            dtElement.setAttribute("path", dt.getPath());
        }
        element.appendChild(dtElement);
    }

    protected void createTypesElement(Element element) {
        Element typesElement = this.doc.createElement("types");
        if (this.module.getInternalTypes() != null) {
            for (XmlModule.InternalType it : this.module.getInternalTypes()) {
                this.createInternalType(typesElement, it);
            }
        }
        element.appendChild(typesElement);
    }

    protected void createInternalType(Element element, XmlModule.InternalType it) {
        Element itElement = this.doc.createElement("internalType");
        itElement.setAttribute("name", it.getName());
        itElement.setAttribute("section", it.getSection());
        itElement.setAttribute("class", it.getTypeClass());
        itElement.setAttribute("transformer", it.getTypeTransformer());
        if (it.getIdFormat() != null && it.getIdFormat().length() > 0) {
            itElement.setAttribute("id-format", it.getIdFormat());
        }
        this.createQuerySystem(itElement, it);
        element.appendChild(itElement);
    }

    protected void createQuerySystem(Element element, XmlModule.InternalType it) {
        Element qsElement = this.doc.createElement("querySystem");
        if (it.getQuerySystemClass() != null && it.getQuerySystemClass().length() > 0) {
            qsElement.setAttribute("class", it.getQuerySystemClass());
        }
        if (it.getLuceneIndexes() != null && it.getLuceneIndexes().length() > 0) {
            qsElement.setAttribute("luceneIndexes", it.getLuceneIndexes());
        }
        if (it.getIndexes() != null) {
            for (XmlModule.InternalType.IndexDescription id : it.getIndexes()) {
                this.createIndexDescription(qsElement, id);
            }
        }
        element.appendChild(qsElement);
    }

    protected void createIndexDescription(Element element, XmlModule.InternalType.IndexDescription id) {
        Element idElement = this.doc.createElement("index");
        if (id.getName() != null) {
            idElement.setAttribute("name", id.getName());
        }
        if (id.getIndexClass() != null) {
            idElement.setAttribute("class", id.getIndexClass());
        }
        if (id.getTable() != null && id.getTable().length() > 0) {
            idElement.setAttribute("table", id.getTable());
        }
        element.appendChild(idElement);
    }
}

