/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml;

import biouml.model.CollectionDescription;
import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.XmlModuleSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.biosoft.util.XmlStream;

public class XmlModuleReader
extends XmlModuleSupport {
    protected static final Logger log = Logger.getLogger(XmlModuleReader.class.getName());
    public static final String VERSION = "0.8.0";
    protected String version = "0.8.0";
    protected InputStream stream;
    protected String name;

    public XmlModuleReader(String name, InputStream stream) {
        this.name = name;
        this.stream = stream;
    }

    public void read(XmlModule xmlModule) throws Exception {
        this.xmlModule = xmlModule;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        StringBuffer buffer = new StringBuffer();
        byte[] b = new byte[65536];
        int length = this.stream.read(b);
        while (length > 0) {
            buffer.append(new String(b, 0, length, StandardCharsets.UTF_8));
            length = this.stream.read(b);
        }
        String xml = buffer.toString();
        xml = xml.replaceAll("[\\x01\\x02\\x03\\x04\\x05\\x06\\x0b\\x0c\\x0f\\x12\\x14\\x16\\x92\\x1a\\x1c\\x1e\\xff]", "?");
        this.stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            doc = builder.parse(this.stream);
        }
        catch (SAXException e) {
            log.log(Level.SEVERE, "Parse module type \"" + this.name + "\" error: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            int finish;
            log.log(Level.SEVERE, "Read module type \"" + this.name + "\" error: " + e.getMessage());
            int start = xml.indexOf("<![CDATA[");
            String newXml = xml;
            if (start >= 0 && (finish = xml.indexOf("]]>")) > start + 9) {
                newXml = xml.substring(0, start + 9) + "Invalid module type" + xml.substring(finish, xml.length());
            }
            this.stream = new ByteArrayInputStream(newXml.getBytes(StandardCharsets.UTF_8));
            try {
                doc = builder.parse(this.stream);
            }
            catch (IOException | SAXException e2) {
                return;
            }
            this.read(doc);
            return;
        }
        this.read(doc);
    }

    protected void read(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        if (root.hasAttribute("version")) {
            this.version = root.getAttribute("version");
        }
        if (root.hasAttribute("title")) {
            this.xmlModule.getInfo().setDisplayName(root.getAttribute("title"));
        }
        if (root.hasAttribute("type")) {
            this.xmlModule.setModuleType(root.getAttribute("type"));
        }
        this.readJdbcConnection(root);
        this.xmlModule.initSections();
        this.readProperties(root);
        this.readDependencies(root);
        this.readTypes(root);
    }

    protected void readJdbcConnection(Element root) {
        Element connectionElement;
        Properties databaseProperties = new Properties();
        if (root.hasAttribute("databaseType")) {
            databaseProperties.put("databaseType", root.getAttribute("databaseType"));
        }
        if (root.hasAttribute("databaseName")) {
            databaseProperties.put("databaseName", root.getAttribute("databaseName"));
        }
        if (root.hasAttribute("databaseVersion")) {
            databaseProperties.put("databaseVersion", root.getAttribute("databaseVersion"));
        }
        if ((connectionElement = XmlModuleReader.getElement(root, "jdbcConnection")) == null) {
            return;
        }
        if (connectionElement.hasAttribute("jdbcDriverClass")) {
            databaseProperties.put("jdbcDriverClass", connectionElement.getAttribute("jdbcDriverClass"));
        }
        if (connectionElement.hasAttribute("jdbcURL")) {
            databaseProperties.put("jdbcURL", connectionElement.getAttribute("jdbcURL"));
        }
        if (connectionElement.hasAttribute("jdbcUser")) {
            databaseProperties.put("jdbcUser", connectionElement.getAttribute("jdbcUser"));
        }
        if (connectionElement.hasAttribute("jdbcPassword")) {
            databaseProperties.put("jdbcPassword", connectionElement.getAttribute("jdbcPassword"));
        }
        this.xmlModule.setDatabaseProperties(databaseProperties);
    }

    protected void readProperties(Element root) {
    }

    protected void readDependencies(Element root) {
        Element dependenciesElement = XmlModuleReader.getElement(root, "dependencies");
        if (dependenciesElement == null) {
            return;
        }
        NodeList list = dependenciesElement.getElementsByTagName("externalModule");
        for (Element iTypeElement : XmlStream.elements((NodeList)list)) {
            try {
                this.readExternalModule(iTypeElement);
            }
            catch (Throwable t) {
                XmlModuleReader.error("ERROR_READ_EXTERNAL_DATABASE", new String[]{this.name, t.getMessage()}, t);
            }
        }
        list = dependenciesElement.getElementsByTagName("graphicNotation");
        for (Element iTypeElement : XmlStream.elements((NodeList)list)) {
            try {
                this.readGraphicNotation(iTypeElement);
            }
            catch (Throwable t) {
                XmlModuleReader.error("ERROR_READ_GRAPHIC_NOTATION", new String[]{this.name, t.getMessage()}, t);
            }
        }
    }

    protected void readExternalModule(Element root) {
        if (root.hasAttribute("name")) {
            String moduleName = root.getAttribute("name");
            NodeList list = root.getElementsByTagName("externalType");
            for (Element eTypeElement : XmlStream.elements((NodeList)list)) {
                try {
                    this.readExternalType(eTypeElement, moduleName);
                }
                catch (Throwable t) {
                    XmlModuleReader.error("ERROR_READ_EXTERNAL_TYPE", new String[]{this.name, t.getMessage()}, t);
                }
            }
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "name", "externalModule"});
        }
    }

    protected void readGraphicNotation(Element root) {
        XmlModule.DiagramTypeDescription dtd = new XmlModule.DiagramTypeDescription();
        if (root.hasAttribute("name")) {
            dtd.setName(root.getAttribute("name"));
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "name", "graphicNotation"});
        }
        if (root.hasAttribute("type")) {
            dtd.setType(root.getAttribute("type"));
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "type", "graphicNotation"});
        }
        if (root.hasAttribute("class")) {
            dtd.setClassName(root.getAttribute("class"));
        }
        if (root.hasAttribute("path")) {
            dtd.setPath(root.getAttribute("path"));
        }
        this.xmlModule.addDiagramType(dtd);
    }

    protected void readExternalType(Element root, String moduleName) {
        String typeName = null;
        if (root.hasAttribute("name")) {
            typeName = root.getAttribute("name");
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "name", "externalType"});
        }
        String sectionName = null;
        if (root.hasAttribute("section")) {
            sectionName = root.getAttribute("section");
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "name", "externalType"});
        }
        if (typeName != null && sectionName != null) {
            CollectionDescription eType = new CollectionDescription();
            eType.setModuleName(moduleName);
            eType.setTypeName(typeName);
            eType.setSectionName(sectionName);
            boolean readOnly = true;
            if (root.hasAttribute("readOnly")) {
                readOnly = Boolean.parseBoolean(root.getAttribute("readOnly"));
            }
            eType.setReadOnly(readOnly);
            this.xmlModule.addExternalType(eType);
        }
    }

    protected void readTypes(Element root) {
        Element examplesElement = XmlModuleReader.getElement(root, "types");
        if (examplesElement == null) {
            return;
        }
        NodeList list = examplesElement.getElementsByTagName("internalType");
        for (Element iTypeElement : XmlStream.elements((NodeList)list)) {
            try {
                this.readInternalType(iTypeElement);
            }
            catch (Throwable t) {
                XmlModuleReader.error("ERROR_READ_INTERNAL_TYPE", new String[]{this.name, t.getMessage()}, t);
            }
        }
    }

    protected void readInternalType(Element root) {
        NodeList list;
        String className;
        XmlModule.InternalType internalType = new XmlModule.InternalType();
        if (root.hasAttribute("section")) {
            internalType.setSection(root.getAttribute("section"));
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "section", "internalType"});
        }
        if (root.hasAttribute("name")) {
            internalType.setName(root.getAttribute("name"));
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "name", "internalType"});
        }
        if (root.hasAttribute("class")) {
            className = root.getAttribute("class");
            internalType.setTypeClass(className);
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "class", "internalType"});
        }
        if (root.hasAttribute("transformer")) {
            className = root.getAttribute("transformer");
            internalType.setTypeTransformer(className);
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "transformer", "internalType"});
        }
        if (root.hasAttribute("id-format")) {
            String idFormat = root.getAttribute("id-format");
            internalType.setIdFormat(idFormat);
        }
        if ((list = root.getElementsByTagName("querySystem")).getLength() > 0) {
            try {
                Element queryElement = (Element)list.item(0);
                this.readQuerySystem(queryElement, internalType);
            }
            catch (Throwable t) {
                XmlModuleReader.error("ERROR_READ_QUERY_SYSTEM", new String[]{this.name, t.getMessage()}, t);
            }
        }
        this.xmlModule.addInternalType(internalType);
    }

    protected void readQuerySystem(Element root, XmlModule.InternalType iType) {
        if (root.hasAttribute("class")) {
            iType.setQuerySystemClass(root.getAttribute("class"));
        }
        if (root.hasAttribute("luceneIndexes")) {
            iType.setLuceneIndexes(root.getAttribute("luceneIndexes"));
        }
        NodeList list = root.getElementsByTagName("index");
        for (Element indexElement : XmlStream.elements((NodeList)list)) {
            try {
                this.readIndex(indexElement, iType);
            }
            catch (Throwable t) {
                XmlModuleReader.error("ERROR_READ_INTERNAL_TYPE", new String[]{this.name, t.getMessage()}, t);
            }
        }
    }

    protected void readIndex(Element root, XmlModule.InternalType iType) {
        XmlModule.InternalType.IndexDescription indexDescription = new XmlModule.InternalType.IndexDescription();
        if (root.hasAttribute("name")) {
            indexDescription.setName(root.getAttribute("name"));
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "name", "index"});
        }
        if (root.hasAttribute("class")) {
            indexDescription.setIndexClass(root.getAttribute("class"));
        } else {
            XmlModuleReader.error("REQUIRED_ATTR_MISSING", new String[]{this.name, "class", "index"});
        }
        if (root.hasAttribute("table")) {
            indexDescription.setTable(root.getAttribute("table"));
        }
        iType.getIndexes().add(indexDescription);
    }
}

