/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml;

import biouml.model.CollectionDescription;
import biouml.model.Diagram;
import biouml.model.DiagramType;
import biouml.model.Module;
import biouml.model.util.DiagramXmlTransformer;
import biouml.model.xml.XmlDiagramType;
import biouml.standard.simulation.access.SimulationResultTransformer;
import biouml.standard.simulation.plot.access.PlotTransformer;
import biouml.standard.type.Stub;
import biouml.standard.type.access.DiagramSqlTransformer;
import biouml.workbench.module.xml.MessageBundle;
import biouml.workbench.module.xml.XmlModuleReader;
import biouml.workbench.module.xml.XmlModuleType;
import biouml.workbench.module.xml.editor.IndexPropertyEditor;
import com.developmentontheedge.beans.BeanInfoEx;
import com.developmentontheedge.beans.editors.StringTagEditorSupport;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.access.Repository;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementReadException;
import ru.biosoft.access.core.DerivedDataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.util.LazyValue;

public class XmlModule
extends Module {
    public static final String XML_DATABASE_FILE = "moduleXml";
    protected static final Logger log = Logger.getLogger(XmlModule.class.getName());
    protected Properties properties;
    protected Properties databaseProperties = new Properties();
    protected String moduleType = "text";
    protected boolean isInit = false;
    protected List<InternalType> internalTypes = new ArrayList<InternalType>();
    protected List<DiagramTypeDescription> diagramTypeList = new ArrayList<DiagramTypeDescription>();

    public XmlModule(DataCollection<?> primaryCollection, Properties properties) throws Exception {
        super(primaryCollection, properties);
        this.properties = properties;
    }

    public void setReadingAvailable(boolean available) {
        this.isInit = !available;
    }

    public void initXmlModule() {
        if (!this.isInit) {
            this.isInit = true;
            String name = this.properties.getProperty("name");
            String filePath = this.properties.getProperty("filePath");
            String moduleXml = this.properties.getProperty(XML_DATABASE_FILE);
            if (name != null && filePath != null && moduleXml != null) {
                try {
                    File xmlFile = new File(filePath, moduleXml);
                    if (!xmlFile.exists()) {
                        this.isInit = false;
                        return;
                    }
                    this.type = new XmlModuleType();
                    this.internalTypes = new ArrayList<InternalType>();
                    this.diagramTypeList = new ArrayList<DiagramTypeDescription>();
                    this.externalTypes = new ArrayList();
                    try (FileInputStream fis = new FileInputStream(xmlFile);){
                        new XmlModuleReader(name, fis).read(this);
                    }
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "can't read module xml properties", t);
                }
            }
        }
    }

    @Override
    protected void applyType(String className) throws Exception {
        this.type = new XmlModuleType();
    }

    public void setDatabaseProperties(Properties properties) {
        this.databaseProperties = properties;
    }

    public Properties getDatabaseProperties() {
        return this.databaseProperties;
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

    public void initSections() {
        this.initStandardSection("Data");
        LocalRepository moduleLR = (LocalRepository)this.getPrimaryCollection();
        if (!this.contains("Diagrams")) {
            try {
                if (this.moduleType.equals("text")) {
                    CollectionFactoryUtils.createTransformedFileCollection((Repository)moduleLR, (String)"Diagrams", (String)"", DiagramXmlTransformer.class);
                } else if (this.moduleType.equals("SQL")) {
                    CollectionFactoryUtils.createTransformedSqlCollection((Repository)moduleLR, (String)"Diagrams", DiagramSqlTransformer.class, Diagram.class, (Properties)this.databaseProperties);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create Diagrams section.", t);
            }
        }
        ((XmlModuleType)this.type).addType(Diagram.class, "Diagrams");
        if (!this.contains("Simulation")) {
            try {
                if (this.moduleType.equals("text")) {
                    Repository simulationDC = CollectionFactoryUtils.createLocalRepository((Repository)moduleLR, (String)"Simulation");
                    CollectionFactoryUtils.createTransformedFileCollection((Repository)simulationDC, (String)"result", (String)"", SimulationResultTransformer.class);
                    CollectionFactoryUtils.createTransformedFileCollection((Repository)simulationDC, (String)"plot", (String)"", PlotTransformer.class);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create Simulation section.", t);
            }
        }
    }

    public void initStandardSection(String sectionName) {
        if (!this.contains(sectionName)) {
            try {
                LocalRepository moduleLR = (LocalRepository)this.getPrimaryCollection().cast(LocalRepository.class);
                CollectionFactoryUtils.createLocalRepository((Repository)moduleLR, (String)sectionName);
            }
            catch (Throwable t) {
                throw ExceptionRegistry.translateException((Throwable)t);
            }
        }
    }

    public List<InternalType> getInternalTypes() {
        return this.internalTypes;
    }

    public void setInternalTypes(List<InternalType> internalTypes) {
        this.internalTypes = internalTypes;
    }

    public void addInternalType(InternalType iType) {
        try {
            DataCollection parent;
            this.internalTypes.add(iType);
            if (!this.contains(iType.section)) {
                this.initStandardSection(iType.section);
            }
            if ((parent = (DataCollection)this.get(iType.section)) != null) {
                Class typeClass = ClassLoading.loadSubClass((String)iType.getTypeClass(), (String)this.pluginNames, DataElement.class);
                ((XmlModuleType)this.type).addType(typeClass, DataElementPath.escapeName((String)iType.section) + "/" + DataElementPath.escapeName((String)iType.getName()));
                if (!parent.contains(iType.getName())) {
                    Class transformer = ClassLoading.loadClass((String)iType.getTypeTransformer(), (String)this.pluginNames);
                    DataCollection repository = parent;
                    while (!(repository instanceof LocalRepository) && repository instanceof DerivedDataCollection) {
                        repository = ((DerivedDataCollection)repository).getPrimaryCollection();
                    }
                    if (this.moduleType.equals("text")) {
                        CollectionFactoryUtils.createTransformedCollection((Repository)((LocalRepository)repository), (String)iType.getName(), (Class)transformer, (Class)typeClass, null, null, (String)".dat", (String)"ID", (String)"ID", (String)"//", null);
                        DataCollection dc = (DataCollection)parent.get(iType.getName());
                        if (dc != null) {
                            if (iType.getIdFormat() != null && iType.getIdFormat().length() > 0) {
                                dc.getInfo().writeProperty("id-format", iType.getIdFormat());
                            }
                            if (iType.getQuerySystemClass() != null && iType.getQuerySystemClass().length() > 0) {
                                dc.getInfo().writeProperty("querySystem", iType.getQuerySystemClass());
                            }
                            if (iType.getLuceneIndexes() != null && iType.getLuceneIndexes().length() > 0) {
                                dc.getInfo().writeProperty("querySystem.indexes", iType.getLuceneIndexes());
                            }
                            for (InternalType.IndexDescription indexDescription : iType.getIndexes()) {
                                dc.getInfo().writeProperty("index." + indexDescription.getName(), indexDescription.getIndexClass());
                                if (indexDescription.getTable() == null) continue;
                                dc.getInfo().writeProperty("index." + indexDescription.getName() + ".table", indexDescription.getTable());
                            }
                        }
                    } else if (this.moduleType.equals("SQL")) {
                        Properties sqlTypeProperties = new Properties();
                        sqlTypeProperties.putAll((Map<?, ?>)this.databaseProperties);
                        if (iType.getIdFormat() != null) {
                            sqlTypeProperties.put("id-format", iType.getIdFormat());
                        }
                        if (iType.getQuerySystemClass() != null) {
                            sqlTypeProperties.put("querySystem", iType.getQuerySystemClass());
                        }
                        if (iType.getLuceneIndexes() != null) {
                            sqlTypeProperties.put("querySystem.indexes", iType.getLuceneIndexes());
                        }
                        for (InternalType.IndexDescription indexDescription : iType.getIndexes()) {
                            sqlTypeProperties.put("index." + indexDescription.getName(), indexDescription.getIndexClass());
                            if (indexDescription.getTable() == null) continue;
                            sqlTypeProperties.put("index." + indexDescription.getName() + ".table", indexDescription.getTable());
                        }
                        CollectionFactoryUtils.createTransformedSqlCollection((Repository)((LocalRepository)repository), (String)iType.getName(), (Class)transformer, (Class)typeClass, (Properties)sqlTypeProperties);
                    }
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not create data collection " + iType.getName(), t);
        }
    }

    public void addExternalType(CollectionDescription eType) {
        if (this.externalTypes == null) {
            this.externalTypes = new ArrayList();
        }
        this.externalTypes.add(eType);
    }

    public void setExternalType(List<CollectionDescription> externalTypes) {
        this.externalTypes = externalTypes;
    }

    public List<DiagramTypeDescription> getDiagramTypes() {
        return this.diagramTypeList;
    }

    public void setDiagramTypes(List<DiagramTypeDescription> diagramTypes) {
        this.diagramTypeList = diagramTypes;
    }

    public void addDiagramType(DiagramTypeDescription dtd) {
        if (this.diagramTypeList == null) {
            this.diagramTypeList = new ArrayList<DiagramTypeDescription>();
        }
        this.diagramTypeList.add(dtd);
        if (dtd.getType().equals("Java")) {
            try {
                ((XmlModuleType)this.type).addDiagramType(ClassLoading.loadSubClass((String)dtd.getClassName(), (String)this.pluginNames, DiagramType.class));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, new DataElementReadException((Throwable)e, (DataElement)this, (Object)("XMLModuleType#" + dtd.getName())).log());
            }
        } else if (dtd.getType().equals("XML")) {
            ((XmlModuleType)this.type).addXmlDiagramType(dtd.path);
        }
    }

    @Override
    public <T extends DataElement> DataCollection<T> getCategory(Class<T> c) {
        if (Stub.class.isAssignableFrom(c)) {
            return null;
        }
        String name = this.type.getCategory(c);
        if (name == null) {
            return null;
        }
        DataElement de = this.getDataElement(name);
        if (de instanceof DataCollection) {
            return (DataCollection)de;
        }
        return null;
    }

    private DataElement getDataElement(String relativeName) {
        XmlModule ancestor = this;
        StringTokenizer st = new StringTokenizer(relativeName, "/");
        DataElement de = null;
        while (st.hasMoreTokens()) {
            try {
                StringBuilder name = new StringBuilder(st.nextToken());
                de = ancestor.getFromCache(name.toString());
                if (de == null) {
                    de = ancestor.get(name.toString());
                }
                if (de == null) {
                    while (st.hasMoreTokens()) {
                        name.append("/").append(st.nextToken());
                        de = ancestor.getFromCache(name.toString());
                        if (de == null) {
                            de = ancestor.get(name.toString());
                        }
                        if (de == null) continue;
                    }
                    if (de == null) {
                        return null;
                    }
                }
                if (!st.hasMoreTokens()) continue;
                if (de instanceof DataCollection) {
                    ancestor = (DataCollection)de;
                    continue;
                }
                name.append("/").append(st.nextToken());
                de = ancestor.getFromCache(name.toString());
                if (de == null) {
                    de = ancestor.get(name.toString());
                }
                if (de == null || !st.hasMoreTokens()) {
                    return de;
                }
                if (de instanceof DataCollection) {
                    ancestor = (DataCollection)de;
                    continue;
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return de;
    }

    public int getSize() {
        this.initXmlModule();
        return super.getSize();
    }

    public DataElement doGet(String name) throws Exception {
        this.initXmlModule();
        return super.doGet(name);
    }

    @Nonnull
    public Iterator iterator() {
        this.initXmlModule();
        return super.iterator();
    }

    @Nonnull
    public List<String> getNameList() {
        this.initXmlModule();
        return super.getNameList();
    }

    @Override
    public List<CollectionDescription> getExternalTypes() {
        this.initXmlModule();
        return super.getExternalTypes();
    }

    public static List<DiagramTypeDescription> getDefaultDiagramTypes() {
        ArrayList<DiagramTypeDescription> result = new ArrayList<DiagramTypeDescription>();
        DiagramTypeDescription dt1 = new DiagramTypeDescription();
        dt1.setName("SemanticNetworkDiagramType");
        dt1.setType("Java");
        dt1.setClassName("biouml.standard.diagram.SemanticNetworkDiagramType");
        result.add(dt1);
        DiagramTypeDescription dt2 = new DiagramTypeDescription();
        dt2.setName("PathwayDiagramType");
        dt2.setType("Java");
        dt2.setClassName("biouml.standard.diagram.PathwayDiagramType");
        result.add(dt2);
        DiagramTypeDescription dt3 = new DiagramTypeDescription();
        dt3.setName("PathwaySimulationDiagramType");
        dt3.setType("Java");
        dt3.setClassName("biouml.standard.diagram.PathwaySimulationDiagramType");
        result.add(dt3);
        DiagramTypeDescription dt4 = new DiagramTypeDescription();
        dt4.setName("CompositeDiagramType");
        dt4.setType("Java");
        dt4.setClassName("biouml.standard.diagram.CompositeDiagramType");
        result.add(dt4);
        return result;
    }

    public static List<InternalType> getDefaultInternalTypes() {
        ArrayList<InternalType> result = new ArrayList<InternalType>();
        InternalType data1 = new InternalType("cell", "Data", "biouml.standard.type.Cell", "ru.biosoft.access.support.BeanInfoEntryTransformer", "CEL0000", "ru.biosoft.access.DefaultQuerySystem", "");
        data1.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data1);
        InternalType data2 = new InternalType("compartment", "Data", "biouml.standard.type.Compartment", "ru.biosoft.access.support.BeanInfoEntryTransformer", "CMP0000", "ru.biosoft.access.DefaultQuerySystem", "");
        data2.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data2);
        InternalType data3 = new InternalType("concept", "Data", "biouml.standard.type.Concept", "ru.biosoft.access.support.BeanInfoEntryTransformer", "CPT000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data3.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data3);
        InternalType data5 = new InternalType("gene", "Data", "biouml.standard.type.Gene", "ru.biosoft.access.support.BeanInfoEntryTransformer", "GEN000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data5.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data5);
        InternalType data6 = new InternalType("literature", "Data", "biouml.standard.type.Publication", "ru.biosoft.access.support.BeanInfoEntryTransformer", "LIT000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data6.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data6);
        InternalType data7 = new InternalType("protein", "Data", "biouml.standard.type.Protein", "ru.biosoft.access.support.BeanInfoEntryTransformer", "PRT000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data7.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data7);
        InternalType data8 = new InternalType("reaction", "Data", "biouml.standard.type.Reaction", "biouml.standard.type.access.ReactionTransformer", "RCT000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data8.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data8);
        InternalType data9 = new InternalType("relation", "Data", "biouml.standard.type.SemanticRelation", "ru.biosoft.access.support.BeanInfoEntryTransformer", "RLT000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data9.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data9);
        InternalType data10 = new InternalType("rna", "Data", "biouml.standard.type.RNA", "ru.biosoft.access.support.BeanInfoEntryTransformer", "RNA000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data10.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data10);
        InternalType data11 = new InternalType("substance", "Data", "biouml.standard.type.Substance", "ru.biosoft.access.support.BeanInfoEntryTransformer", "SBS000000", "ru.biosoft.access.DefaultQuerySystem", "");
        data11.getIndexes().add(new InternalType.IndexDescription("title", "biouml.standard.type.access.TitleIndex"));
        result.add(data11);
        InternalType dict1 = new InternalType("database info", "Dictionaries", "biouml.standard.type.DatabaseInfo", "ru.biosoft.access.support.BeanInfoEntryTransformer", "", "", "");
        result.add(dict1);
        InternalType dict2 = new InternalType("relation type", "Dictionaries", "biouml.standard.type.RelationType", "ru.biosoft.access.support.BeanInfoEntryTransformer", "", "", "");
        result.add(dict2);
        InternalType dict3 = new InternalType("species", "Dictionaries", "biouml.standard.type.Species", "ru.biosoft.access.support.BeanInfoEntryTransformer", "", "", "");
        result.add(dict3);
        InternalType dict4 = new InternalType("unit", "Dictionaries", "biouml.standard.type.Unit", "ru.biosoft.access.support.BeanInfoEntryTransformer", "", "", "");
        result.add(dict4);
        return result;
    }

    public static class DiagramTypeDescriptionBeanInfo
    extends BeanInfoEx {
        public DiagramTypeDescriptionBeanInfo() {
            super(DiagramTypeDescription.class, null);
        }

        public void initProperties() throws Exception {
            super.initProperties();
            this.property("name").titleRaw("Name").descriptionRaw("Diagram type name").add();
            this.property("type").editor(TypeEditor.class).titleRaw("Type").descriptionRaw("Type").add();
            this.property("className").titleRaw("Class name").descriptionRaw("Name of class for Java types").add();
            this.property("path").editor(PathEditor.class).titleRaw("Path").descriptionRaw("Path for XML types").add();
        }

        public static class PathEditor
        extends StringTagEditorSupport {
            private static final LazyValue<String[]> names = new LazyValue("XML diagram types", () -> (String[])StreamEx.of((Stream)XmlDiagramType.getTypesCollection().names()).prepend((Object)"").toArray(String[]::new));

            public PathEditor() {
                super(PathEditor.getNames());
            }

            public static String[] getNames() {
                return (String[])((String[])names.get()).clone();
            }
        }

        public static class TypeEditor
        extends StringTagEditorSupport {
            public TypeEditor() {
                super(MessageBundle.class.getName(), MessageBundle.class, "COLLECTIONDESCRIPTION_TYPE_STATES");
            }
        }
    }

    public static class DiagramTypeDescription {
        protected String name;
        protected String type;
        protected String className;
        protected String path;

        public DiagramTypeDescription clone() {
            DiagramTypeDescription result = new DiagramTypeDescription();
            result.setName(this.name);
            result.setType(this.type);
            result.setClassName(this.className);
            result.setPath(this.path);
            return result;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class InternalTypeBeanInfo
    extends BeanInfoEx {
        public InternalTypeBeanInfo() {
            super(InternalType.class, null);
        }

        public void initProperties() throws Exception {
            super.initProperties();
            this.property("name").titleRaw("Name").descriptionRaw("Collection name").add();
            this.property("section").titleRaw("Section").descriptionRaw("Section").add();
            this.property("typeClass").titleRaw("Class").descriptionRaw("Collection elements type").add();
            this.property("typeTransformer").titleRaw("Transformer").descriptionRaw("Transformer").add();
            this.property("idFormat").titleRaw("ID format").descriptionRaw("ID format").add();
            this.property("querySystemClass").titleRaw("Query system").descriptionRaw("Query system class").add();
            this.property("luceneIndexes").titleRaw("Indexes").descriptionRaw("Indexes").add();
            this.property("indexes").editor(IndexPropertyEditor.class).titleRaw("Index list").descriptionRaw("Index list").add();
        }
    }

    public static class InternalType {
        protected String section;
        protected String name;
        protected String typeClass;
        protected String typeTransformer;
        protected String idFormat;
        protected String querySystemClass;
        protected String luceneIndexes;
        protected List<IndexDescription> indexes = new ArrayList<IndexDescription>();

        public InternalType() {
            this.name = "";
            this.section = "";
            this.typeClass = "";
            this.typeTransformer = "";
            this.idFormat = "";
            this.querySystemClass = "";
            this.luceneIndexes = "";
        }

        public InternalType(String name, String section, String typeClass, String typeTransformer, String idFormat, String querySystemClass, String luceneIndexes) {
            this.name = name;
            this.section = section;
            this.typeClass = typeClass;
            this.typeTransformer = typeTransformer;
            this.idFormat = idFormat;
            this.querySystemClass = querySystemClass;
            this.luceneIndexes = luceneIndexes;
        }

        public InternalType clone() {
            InternalType result = new InternalType();
            result.setName(this.name);
            result.setSection(this.section);
            result.setTypeClass(this.typeClass);
            result.setTypeTransformer(this.typeTransformer);
            result.setIdFormat(this.idFormat);
            result.setQuerySystemClass(this.querySystemClass);
            result.setLuceneIndexes(this.luceneIndexes);
            ArrayList<IndexDescription> newIndexes = new ArrayList<IndexDescription>();
            for (IndexDescription id : this.indexes) {
                newIndexes.add(id.clone());
            }
            result.setIndexes(newIndexes);
            return result;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }

        public String getTypeClass() {
            return this.typeClass;
        }

        public void setTypeClass(String typeClass) {
            this.typeClass = typeClass;
        }

        public String getTypeTransformer() {
            return this.typeTransformer;
        }

        public void setTypeTransformer(String typeTransformer) {
            this.typeTransformer = typeTransformer;
        }

        public String getIdFormat() {
            return this.idFormat;
        }

        public void setIdFormat(String idFormat) {
            this.idFormat = idFormat;
        }

        public String getLuceneIndexes() {
            return this.luceneIndexes;
        }

        public void setLuceneIndexes(String luceneIndexes) {
            this.luceneIndexes = luceneIndexes;
        }

        public String getQuerySystemClass() {
            return this.querySystemClass;
        }

        public void setQuerySystemClass(String querySystemClass) {
            this.querySystemClass = querySystemClass;
        }

        public List<IndexDescription> getIndexes() {
            return this.indexes;
        }

        public void setIndexes(List<IndexDescription> indexes) {
            this.indexes = indexes;
        }

        public static class IndexDescriptionBeanInfo
        extends BeanInfoEx {
            public IndexDescriptionBeanInfo() {
                super(IndexDescription.class, null);
            }

            public void initProperties() throws Exception {
                super.initProperties();
                this.property("name").titleRaw("Name").descriptionRaw("Field name");
                this.property("indexClass").titleRaw("Class").descriptionRaw("Index class");
                this.property("table").titleRaw("Table").descriptionRaw("DB table");
            }
        }

        public static class IndexDescription {
            protected String name;
            protected String indexClass;
            protected String table;

            public IndexDescription() {
            }

            public IndexDescription(String name, String indexClass) {
                this.name = name;
                this.indexClass = indexClass;
            }

            public IndexDescription clone() {
                IndexDescription result = new IndexDescription();
                result.setName(this.name);
                result.setIndexClass(this.indexClass);
                result.setTable(this.table);
                return result;
            }

            public String getIndexClass() {
                return this.indexClass;
            }

            public void setIndexClass(String indexClass) {
                this.indexClass = indexClass;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getTable() {
                return this.table;
            }

            public void setTable(String table) {
                this.table = table;
            }
        }
    }
}

