/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module.xml;

import biouml.workbench.BioUMLApplication;
import biouml.workbench.module.xml.XmlModule;
import biouml.workbench.module.xml.XmlModuleWriter;
import biouml.workbench.module.xml.editor.XmlModuleDialog;
import com.developmentontheedge.application.Application;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class EditModuleAction
extends AbstractAction {
    public static final String KEY = "Edit module";
    public static final String DATABASE = "Module";
    protected static final Logger log = Logger.getLogger("biouml.workbench.module.xml.EditModuleAction");

    public EditModuleAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XmlModule module = (XmlModule)((Object)this.getValue(DATABASE));
        module.initXmlModule();
        BioUMLApplication app = (BioUMLApplication)Application.getApplicationFrame();
        XmlModuleDialog xmd = new XmlModuleDialog((JFrame)((Object)app), "Edit module properties", module.getOrigin(), module);
        if (xmd.doModal()) {
            String path = module.getPath().getAbsolutePath();
            try (FileOutputStream fos = new FileOutputStream(path + File.separator + module.getName() + ".xml");){
                XmlModuleWriter xmw = new XmlModuleWriter(fos);
                xmw.write(module);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not save changes", t);
            }
            module.initXmlModule();
        }
    }
}

