/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.log.LogTextPanel;
import com.developmentontheedge.log.PatternFormatter;
import com.developmentontheedge.log.TextPaneAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListener;

public class StatusInfoDialog
extends OkCancelDialog
implements JobControlListener {
    protected TextPaneAppender appender = new TextPaneAppender((Formatter)new PatternFormatter("[%4$-7s] :  %5$s%n"), "logTextPanel");
    private JLabel infoLabel = null;
    private JProgressBar progressBar = null;
    private JobControl jobControl = null;

    public StatusInfoDialog(JFrame frame, String title, Logger cat, JobControl jobControl) {
        super(frame, title);
        LogTextPanel appenderPanel = this.appender.getLogTextPanel();
        appenderPanel.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        appenderPanel.setPreferredSize(new Dimension(400, 300));
        cat.setLevel(Level.INFO);
        cat.addHandler((Handler)this.appender);
        this.jobControl = jobControl;
        jobControl.addListener((JobControlListener)this);
        this.infoLabel = new JLabel();
        this.infoLabel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.progressBar = new JProgressBar(0, 100);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.infoLabel, "Center");
        topPanel.add((Component)this.progressBar, "South");
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        content.add((Component)topPanel, "North");
        content.add((Component)appenderPanel, "Center");
        this.setContent(content);
        this.cancelButton.setVisible(false);
        this.transferFocus();
        this.setDefaultCloseOperation(0);
    }

    public void setInfo(String info) {
        this.infoLabel.setText(info);
    }

    public void setMinMax(int min, int max) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
    }

    public void setPreparedness(int value) {
        this.progressBar.setValue(value);
    }

    public void startProcess(Thread thread) {
        this.okButton.setEnabled(false);
        this.pack();
        ApplicationUtils.moveToCenter((Component)((Object)this));
        thread.start();
        this.setVisible(true);
    }

    protected void okPressed() {
        this.setVisible(false);
        this.dispose();
    }

    protected void cancelPressed() {
        this.jobControl.terminate();
    }

    public void success() {
        this.jobControl.terminate();
        this.okButton.setEnabled(true);
        this.progressBar.setValue(0);
        this.infoLabel.setText(BioUMLApplication.getMessageBundle().getResourceString("FINISHED_SUCCESS"));
    }

    public void fails() {
        this.jobControl.terminate();
        this.okButton.setEnabled(true);
        this.progressBar.setValue(0);
        this.infoLabel.setText(BioUMLApplication.getMessageBundle().getResourceString("FINISHED_ERROR"));
    }

    public void valueChanged(JobControlEvent event) {
        this.progressBar.setValue(event.getPreparedness());
    }

    public void jobStarted(JobControlEvent event) {
    }

    public void jobTerminated(JobControlEvent event) {
    }

    public void jobPaused(JobControlEvent event) {
    }

    public void jobResumed(JobControlEvent event) {
    }

    public void resultsReady(JobControlEvent event) {
    }
}

