/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.Module;
import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.GUI;

public class RemoveModuleAction
extends AbstractAction {
    public static final String KEY = "Remove module";
    public static final String DATABASE = "Database";
    protected static final Logger log = Logger.getLogger("biouml.workbench.module.RemoveModuleAction");

    public RemoveModuleAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Module module = (Module)((Object)this.getValue(DATABASE));
        String moduleName = module.getName();
        String message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("CONFIRM_REMOVE_DATABASE"), moduleName);
        int res = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message);
        if (res == 0) {
            try {
                this.closeDocumentsFromModule(module);
                DataCollection origin = module.getOrigin();
                origin.remove(moduleName);
                File dir = module.getPath();
                ApplicationUtils.removeDir((File)dir);
                System.gc();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Removing the module " + moduleName + " error", ex);
            }
        }
    }

    private void closeDocumentsFromModule(Module module) {
        try {
            Document oldActiveDocument = GUI.getManager().getCurrentDocument();
            for (Document document : GUI.getManager().getDocuments()) {
                Object model = document.getModel();
                if (!(model instanceof DataElement) || Module.optModule((DataElement)model) != module) continue;
                if (document == oldActiveDocument) {
                    oldActiveDocument = null;
                }
                GUI.getManager().removeDocument(document);
            }
            if (oldActiveDocument != null) {
                GUI.getManager().addDocument(oldActiveDocument);
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Maybe not all diagrams from removed module '" + module.getName() + "'closed. error:", t);
        }
    }
}

