/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.ModuleType;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.Repository;

public class NewModuleDialog
extends OkCancelDialog {
    public static final String EXTENSION_POINT = "biouml.workbench.moduleType";
    public static final String CLASS_ATTR = "class";
    public static final String PRIORITY_ATTR = "priority";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String DESCRIPTION_ATTR = "description";
    protected static final Logger log = Logger.getLogger(NewModuleDialog.class.getName());
    protected Map<String, ModuleInfo> extensionMap;
    protected List<ModuleInfo> extensionsList;
    protected MessageBundle resources;
    protected JTextField moduleName;
    protected JComboBox<String> moduleType;
    protected JEditorPane moduleDescription;
    protected JPanel content;

    public NewModuleDialog(JDialog dialog) {
        super(dialog, "");
        this.init();
    }

    public NewModuleDialog(JFrame frame) {
        super(frame, "");
        this.init();
    }

    protected String message(String key, Object[] params) {
        String message = this.resources.getString(key);
        return MessageFormat.format(message, params);
    }

    protected void init() {
        this.resources = BioUMLApplication.getMessageBundle();
        this.setTitle(this.resources.getResourceString("NEW_DATABASE_DIALOG_TITLE"));
        this.content = new JPanel(new BorderLayout());
        this.moduleName = new JTextField(15);
        this.moduleType = new JComboBox();
        this.loadExtensions();
        Iterator<ModuleInfo> it = this.extensionsList.iterator();
        while (it.hasNext()) {
            this.moduleType.addItem(it.next().name);
        }
        JPanel fields = new JPanel(new GridBagLayout());
        this.content.add((Component)fields, "Center");
        fields.setBorder(new EmptyBorder(10, 10, 10, 10));
        fields.add((Component)new JLabel(this.resources.getResourceString("NEW_DATABASE_DIALOG_NAME")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        fields.add((Component)this.moduleName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        fields.add((Component)new JLabel(this.resources.getResourceString("NEW_DATABASE_DIALOG_TYPE")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        fields.add(this.moduleType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.moduleDescription = new JEditorPane("text/html", "");
        this.moduleDescription.setEditable(false);
        this.moduleDescription.setPreferredSize(new Dimension(250, 150));
        this.validateModuleDescription();
        JPanel descriptionPanel = new JPanel(new BorderLayout(10, 10));
        this.content.add((Component)descriptionPanel, "South");
        descriptionPanel.add((Component)new JLabel(this.resources.getResourceString("NEW_DATABASE_DIALOG_DESCRIPTION")), "North");
        descriptionPanel.add((Component)new JScrollPane(this.moduleDescription), "Center");
        this.moduleName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String name = NewModuleDialog.this.moduleName.getText();
                NewModuleDialog.this.okButton.setEnabled(name != null && name.length() > 0);
            }
        });
        this.moduleType.addItemListener(e -> this.validateModuleDescription());
        this.setContent(this.content);
        this.okButton.setEnabled(false);
    }

    protected void validateModuleDescription() {
        Object item = this.moduleType.getSelectedItem();
        String description = this.extensionMap.get((Object)item).description;
        if (description == null || description.length() == 0) {
            description = this.message("NEW_DATABASE_DESCRIPTION_ABSENTS", new String[]{item.toString()});
        }
        this.moduleDescription.setText("<html>" + description + "</html>");
    }

    protected void okPressed() {
        this.createNewModule();
        super.okPressed();
    }

    protected void createNewModule() {
        String name = null;
        Object type = null;
        try {
            name = this.moduleName.getText();
            ModuleType module = this.extensionMap.get((Object)this.moduleType.getSelectedItem()).type;
            module.createModule((Repository)CollectionFactoryUtils.getDatabases(), name);
        }
        catch (Throwable t) {
            String title = this.resources.getResourceString("NEW_DATABASE_ERROR_TITLE");
            String message = this.message("NEW_DATABASE_ERROR", new String[]{name, type, t.getMessage()});
            JOptionPane.showMessageDialog((Component)((Object)this), message, title, 0);
            log.log(Level.SEVERE, message, t);
        }
    }

    protected void loadExtensions() {
        IExtension[] extensions;
        this.extensionMap = new HashMap<String, ModuleInfo>();
        this.extensionsList = new ArrayList<ModuleInfo>();
        IExtensionPoint point = Application.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (point == null) {
            log.log(Level.SEVERE, "NEW_DATABASE_EXTENSION_ABSENTS");
            return;
        }
        for (IExtension extension : extensions = point.getExtensions()) {
            IConfigurationElement element = extension.getConfigurationElements()[0];
            String elementName = extension.getUniqueIdentifier();
            String pluginId = extension.getNamespaceIdentifier();
            try {
                String displayName = element.getAttribute(DISPLAY_NAME_ATTR);
                Class clazz = ClassLoading.loadSubClass((String)element.getAttribute(CLASS_ATTR), (String)pluginId, ModuleType.class);
                ModuleType provider = (ModuleType)clazz.newInstance();
                if (provider.canCreateEmptyModule()) {
                    ModuleInfo info = new ModuleInfo(displayName, provider);
                    info.description = element.getAttribute(DESCRIPTION_ATTR);
                    String priorityAttribute = element.getAttribute(PRIORITY_ATTR);
                    if (priorityAttribute != null) {
                        try {
                            info.priority = Double.parseDouble(priorityAttribute);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.extensionMap.put(displayName, info);
                    this.extensionsList.add(info);
                    continue;
                }
                log.warning(this.message("NEW_DATABASE_EXTENSION_WARN", new String[]{provider.toString(), elementName}));
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, this.message("NEW_DATABASE_EXTENSION_ERROR", new String[]{elementName, t.getMessage()}), t);
            }
        }
        Collections.sort(this.extensionsList, new ModuleInfoComparator());
    }

    public static class ModuleInfoComparator
    implements Comparator<ModuleInfo> {
        @Override
        public int compare(ModuleInfo o1, ModuleInfo o2) {
            double p1 = o1.priority;
            double p2 = o2.priority;
            return (int)Math.signum(p2 - p1);
        }
    }

    private static class ModuleInfo {
        public double priority = Double.NEGATIVE_INFINITY;
        public ModuleType type;
        public String description;
        public String name;

        private ModuleInfo(String displayName, ModuleType moduleType) {
            this.type = moduleType;
            this.name = displayName;
        }
    }
}

