/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.util.ModulePackager;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.module.StatusInfoDialog;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.beans.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import one.util.streamex.StreamEx;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.CreateDataCollectionController;
import ru.biosoft.access.CreateDataCollectionDefaultController;
import ru.biosoft.access.Repository;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;

public class ModulesActivatingDialog
extends OkCancelDialog {
    private static final String DEFAULT_DATABASE_DISTRIBS_DIR = "./module distributives";
    protected static final Logger log = Logger.getLogger(ModulesActivatingDialog.class.getName());
    private HashMap<JCheckBox, JarFile> mapping = new HashMap();

    public static void checkNewModules() {
        ModulesActivatingDialog dialog;
        File rootModuleDistribsDir = new File(DEFAULT_DATABASE_DISTRIBS_DIR);
        if (!rootModuleDistribsDir.exists()) {
            rootModuleDistribsDir.mkdir();
        }
        FileFilter bmdFilesFilter = pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".bmd");
        File[] bmdFiles = rootModuleDistribsDir.listFiles(bmdFilesFilter);
        HashSet<JarFile> notActiveModules = new HashSet<JarFile>();
        for (File bmdFile : bmdFiles) {
            String moduleName = null;
            JarFile moduleFile = null;
            try {
                moduleFile = new JarFile(bmdFile);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Error at creating jar file from " + bmdFile.getName(), ioe);
                continue;
            }
            moduleName = ModulePackager.getModuleAttribute(moduleFile, "Module-Name");
            if (moduleName == null) continue;
            DataCollection root = CollectionFactoryUtils.getDatabases();
            try {
                DataCollection dc = (DataCollection)root.get(moduleName);
                if (dc != null) continue;
                notActiveModules.add(moduleFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (notActiveModules.size() > 0 && (dialog = new ModulesActivatingDialog((JFrame)Application.getApplicationFrame(), notActiveModules)).doModal()) {
            Set<JarFile> modulesToActivate = dialog.getModulesToActivate();
            for (JarFile moduleFile : modulesToActivate) {
                ModulesActivatingDialog.importModule(moduleFile);
            }
        }
    }

    public static void importModule(final JarFile moduleFile) {
        final Logger cat = Logger.getLogger(ModulePackager.class.getName());
        final FunctionJobControl jobControl = new FunctionJobControl(null);
        final String importingStr = BioUMLApplication.getMessageBundle().getResourceString("IMPORTING");
        final StatusInfoDialog infoDialog = new StatusInfoDialog((JFrame)Application.getApplicationFrame(), importingStr, cat, (JobControl)jobControl);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    infoDialog.setInfo(importingStr + "...");
                    CreateDataCollectionDefaultController controller = new CreateDataCollectionDefaultController((JDialog)((Object)infoDialog)){

                        public int fileAlreadyExists(File file) {
                            return 2;
                        }
                    };
                    controller.setJobControl(jobControl);
                    Repository repository = (Repository)CollectionFactoryUtils.getDatabases();
                    ModulePackager.importModule((JDialog)((Object)infoDialog), moduleFile, repository, (CreateDataCollectionController)controller);
                }
                catch (Throwable t) {
                    cat.log(Level.SEVERE, t.getMessage());
                    infoDialog.fails();
                    return;
                }
                infoDialog.success();
            }
        };
        infoDialog.startProcess(thread);
    }

    public ModulesActivatingDialog(JDialog dialog, Set<JarFile> notActiveModules) {
        super(dialog, BioUMLApplication.getMessageBundle().getResourceString("DATABASES_ACTIVATING_DIALOG_TITLE"));
        this.init(notActiveModules);
    }

    public ModulesActivatingDialog(JFrame frame, Set<JarFile> notActiveModules) {
        super(frame, BioUMLApplication.getMessageBundle().getResourceString("DATABASES_ACTIVATING_DIALOG_TITLE"));
        this.init(notActiveModules);
    }

    public Set<JarFile> getModulesToActivate() {
        return StreamEx.ofValues(this.mapping, AbstractButton::isSelected).toSet();
    }

    private void init(Set<JarFile> notActiveModules) {
        JPanel content = new JPanel(new BorderLayout());
        JPanel upperPanel = new JPanel(new GridLayout(2, 0));
        upperPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        String upperLabel1Text = BioUMLApplication.getMessageBundle().getResourceString("DATABASES_ACTIVATING_DIALOG_NOT_ACTIVE_DATABASES_DETECTED");
        JLabel upperLabel1 = new JLabel(upperLabel1Text);
        String upperLabel2Text = BioUMLApplication.getMessageBundle().getResourceString("DATABASES_ACTIVATING_DIALOG_SELECT_DATABASES");
        JLabel upperLabel2 = new JLabel(upperLabel2Text);
        upperPanel.add(upperLabel1);
        upperPanel.add(upperLabel2);
        content.add((Component)upperPanel, "North");
        String notShowAgainCBText = BioUMLApplication.getMessageBundle().getResourceString("DO_NOT_SHOW_DIALOG_AGAIN");
        JCheckBox notShowAgainCB = new JCheckBox(notShowAgainCBText);
        notShowAgainCB.setBorder(new EmptyBorder(5, 5, 5, 5));
        content.add((Component)notShowAgainCB, "South");
        notShowAgainCB.addActionListener(e -> {
            Preferences preferences = Application.getPreferences();
            preferences.setValue("checkModulesOnStartup", (Object)(!notShowAgainCB.isSelected() ? 1 : 0));
        });
        JPanel centerPanel = new JPanel(new GridBagLayout());
        int y = 0;
        for (JarFile jarFile : notActiveModules) {
            JCheckBox checkBox = new JCheckBox();
            JPanel infoPanel = ModulesActivatingDialog.createModuleInfoPanel(jarFile);
            this.mapping.put(checkBox, jarFile);
            centerPanel.add((Component)checkBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
            centerPanel.add((Component)infoPanel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
            ++y;
        }
        content.add((Component)new JScrollPane(centerPanel), "Center");
        this.setContent(content);
        this.okButton.setText(BioUMLApplication.getMessageBundle().getResourceString("BUTTON_CONTINUE"));
        this.okButton.setPreferredSize(null);
        this.cancelButton.setPreferredSize(this.okButton.getPreferredSize());
    }

    public boolean doModal() {
        Preferences preferences = Application.getPreferences();
        boolean checkModulesOnStartup = preferences.getBooleanValue("checkModulesOnStartup", true);
        return checkModulesOnStartup ? super.doModal() : false;
    }

    protected static JPanel createModuleInfoPanel(JarFile jarFile) {
        JPanel panel = new JPanel(new GridLayout(3, 0));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        String moduleName = ModulePackager.getModuleAttribute(jarFile, "Module-Name");
        String moduleVersion = ModulePackager.getModuleAttribute(jarFile, "Module-Version");
        String moduleDescription = ModulePackager.getModuleAttribute(jarFile, "Module-Description");
        panel.add(new JLabel(moduleName));
        panel.add(new JLabel(moduleVersion));
        panel.add(new JLabel(moduleDescription));
        return panel;
    }
}

