/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.util.ModulePackager;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.module.BMDFileFilter;
import biouml.workbench.module.ModuleInfoDialog;
import biouml.workbench.module.ModuleReplaceDialog;
import biouml.workbench.module.ModulesActivatingDialog;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Preferences;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import ru.biosoft.access.CollectionFactoryUtils;

public class ModuleSetupAction
extends AbstractAction {
    public static final String KEY = "Module Setup";
    public static final String PREFERENCES_IMPORT_DIRECTORY = "moduleSetup.importDirectory";
    protected static final Logger log = Logger.getLogger(ModuleSetupAction.class.getName());

    public ModuleSetupAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String key = "dialogs/moduleSetup.importDirectory";
        String importDirectory = Application.getPreferences().getStringValue(key, ".");
        JFileChooser chooser = new JFileChooser(new File(importDirectory));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new BMDFileFilter());
        int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
        if (res == 0) {
            File file = chooser.getSelectedFile();
            importDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            this.savePreferences(importDirectory);
            JarFile moduleFile = null;
            try {
                moduleFile = new JarFile(file);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Error at creating jar file from " + file.getName(), ioe);
                return;
            }
            if (moduleFile != null) {
                boolean showInfoDialog = true;
                String moduleName = ModulePackager.getModuleAttribute(moduleFile, "Module-Name");
                File moduleDir = ModulePackager.getModuleDir(CollectionFactoryUtils.getDatabases().getCompletePath(), moduleName);
                File infoFile = new File(moduleDir, "info");
                if (infoFile.exists() && infoFile.isFile()) {
                    Manifest existedVersionManifest = null;
                    Manifest newVersionManifest = null;
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(infoFile));
                        existedVersionManifest = new Manifest(in);
                        newVersionManifest = moduleFile.getManifest();
                    }
                    catch (IOException ex) {
                        log.log(Level.SEVERE, "Reading " + infoFile.getPath() + " error", ex);
                    }
                    if (existedVersionManifest != null && newVersionManifest != null) {
                        String title = BioUMLApplication.getMessageBundle().getResourceString("DATABASE_REPLACE_DIALOG_TITLE");
                        ModuleReplaceDialog moduleReplaceDialog = new ModuleReplaceDialog((JFrame)Application.getApplicationFrame(), title, existedVersionManifest, newVersionManifest);
                        if (!moduleReplaceDialog.doModal()) {
                            return;
                        }
                        showInfoDialog = false;
                    }
                }
                if (showInfoDialog) {
                    String title = BioUMLApplication.getMessageBundle().getResourceString("DATABASE_INFO_DIALOG_TITLE");
                    ModuleInfoDialog moduleInfoDialog = new ModuleInfoDialog((JFrame)Application.getApplicationFrame(), title, moduleFile);
                    if (!moduleInfoDialog.doModal()) {
                        return;
                    }
                }
                ModulesActivatingDialog.importModule(moduleFile);
            }
        }
    }

    protected void savePreferences(String importDirectory) {
        String key = "dialogs/moduleSetup.importDirectory";
        if (Application.getPreferences().getProperty(key) != null) {
            Application.getPreferences().setValue(key, (Object)importDirectory);
        } else {
            try {
                MessageBundle messageBundle = BioUMLApplication.getMessageBundle();
                Preferences preferences = Application.getPreferences().getPreferencesValue("dialogs");
                preferences.add(new DynamicProperty(PREFERENCES_IMPORT_DIRECTORY, messageBundle.getResourceString("DATABASE_IMPORT_DIRECTORY_PN"), messageBundle.getResourceString("DATABASE_IMPORT_DIRECTORY_PD"), String.class, (Object)importDirectory));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error saving module directory '" + importDirectory + "' in preferences ", ex);
            }
        }
    }
}

