/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ModuleReplaceDialog
extends OkCancelDialog {
    protected JPanel content;

    public ModuleReplaceDialog(JDialog dialog, String title, Manifest existedVersionManifest, Manifest newVersionManifest) {
        super(dialog, title);
        this.init(existedVersionManifest, newVersionManifest);
    }

    public ModuleReplaceDialog(JFrame frame, String title, Manifest existedVersionManifest, Manifest newVersionManifest) {
        super(frame, title);
        this.init(existedVersionManifest, newVersionManifest);
    }

    private void init(Manifest existedVersionManifest, Manifest newVersionManifest) {
        Attributes existedVersionAttributes = existedVersionManifest.getMainAttributes();
        Attributes newVersionAttributes = newVersionManifest.getMainAttributes();
        String existedModuleName = existedVersionAttributes.getValue("Module-Name");
        String message1 = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("MESSAGE_DATABASE_EXIST"), existedModuleName);
        String message2 = BioUMLApplication.getMessageBundle().getResourceString("REPLACE_EXISTED_VERSION");
        this.content = new JPanel(new GridBagLayout());
        this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
        String existedVersionText = BioUMLApplication.getMessageBundle().getResourceString("EXISTED_VERSION");
        String newVersionText = BioUMLApplication.getMessageBundle().getResourceString("NEW_VERSION");
        JPanel existedModuleInfoPanel = this.createModuleInfoPanel(existedVersionAttributes, " " + existedVersionText + " ");
        JPanel newModuleInfoPanel = this.createModuleInfoPanel(newVersionAttributes, " " + newVersionText + " ");
        this.content.add((Component)new JLabel(message1), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(message2), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.content.add((Component)existedModuleInfoPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.content.add((Component)newModuleInfoPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setContent(this.content);
        this.okButton.setText(BioUMLApplication.getMessageBundle().getResourceString("BUTTON_YES"));
        this.cancelButton.setText(BioUMLApplication.getMessageBundle().getResourceString("BUTTON_CANCEL"));
    }

    private JPanel createModuleInfoPanel(Attributes attributes, String title) {
        String moduleName = attributes.getValue("Module-Name");
        String moduleVersion = attributes.getValue("Module-Version");
        String moduleDesc = attributes.getValue("Module-Description");
        JPanel moduleInfoPanel = new JPanel(new GridBagLayout());
        moduleInfoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        moduleInfoPanel.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("NAME")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        moduleInfoPanel.add((Component)new JLabel(moduleName), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        moduleInfoPanel.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("VERSION")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        moduleInfoPanel.add((Component)new JLabel(moduleVersion), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        moduleInfoPanel.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DESCRIPTION")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        moduleInfoPanel.add((Component)new JLabel(moduleDesc), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        return moduleInfoPanel;
    }
}

