/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.util.ModulePackager;
import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModuleInfoDialog
extends OkCancelDialog {
    protected JPanel content;
    protected static final Logger log = Logger.getLogger(ModuleInfoDialog.class.getName());

    public ModuleInfoDialog(JDialog dialog, String title, JarFile jarFile) {
        super(dialog, title);
        this.init(jarFile);
    }

    public ModuleInfoDialog(JFrame frame, String title, JarFile jarFile) {
        super(frame, title);
        this.init(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(JarFile jarFile) {
        String moduleName = ModulePackager.getModuleAttribute(jarFile, "Module-Name");
        String moduleVersion = ModulePackager.getModuleAttribute(jarFile, "Module-Version");
        String moduleDesc = ModulePackager.getModuleAttribute(jarFile, "Module-Description");
        if (moduleName != null) {
            byte[] buf = new byte[]{};
            InputStream stream = null;
            try {
                try {
                    JarEntry jarEntry = jarFile.getJarEntry("license");
                    if (jarEntry != null) {
                        stream = jarFile.getInputStream(jarEntry);
                        buf = new byte[stream.available()];
                        stream.read(buf);
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Exception ioe) {
                log.log(Level.SEVERE, "Error at reading license file from " + jarFile.getName(), ioe);
            }
            String licenseStr = null;
            if (buf.length > 0) {
                licenseStr = new String(buf);
            }
            this.content = new JPanel(new GridBagLayout());
            this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("NAME")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.content.add((Component)new JLabel(moduleName), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
            this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("VERSION")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.content.add((Component)new JLabel(moduleVersion), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
            this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DESCRIPTION")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.content.add((Component)new JLabel(moduleDesc), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
            if (licenseStr != null) {
                JTextPane textPane = new JTextPane();
                textPane.setEditable(false);
                textPane.setBackground(this.content.getBackground());
                textPane.setText(licenseStr);
                this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("LICENSE")), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
                this.content.add((Component)textPane, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
                JCheckBox acceptCheckBox = new JCheckBox();
                acceptCheckBox.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        JCheckBox checkBox = (JCheckBox)e.getSource();
                        ModuleInfoDialog.this.okButton.setEnabled(checkBox.isSelected());
                    }
                });
                this.okButton.setEnabled(false);
                this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("ACCEPT")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
                this.content.add((Component)acceptCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
            }
        }
        this.setContent(this.content);
        this.okButton.setText(BioUMLApplication.getMessageBundle().getResourceString("BUTTON_CONTINUE"));
        this.okButton.setPreferredSize(null);
        this.cancelButton.setPreferredSize(this.okButton.getPreferredSize());
    }
}

