/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.Module;
import biouml.model.util.ModulePackager;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.module.BMDFileFilter;
import biouml.workbench.module.StatusInfoDialog;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;

public class ModuleExportDialog
extends OkCancelDialog {
    protected JPanel content;
    protected File selectedFile;
    protected Manifest manifest;
    protected Module module;
    protected JTextField nameTextField = new JTextField();
    protected JTextField versionTextField = new JTextField();
    protected JTextField descTextField = new JTextField();
    protected JTextField pathTextField = new JTextField(20);

    public ModuleExportDialog(JDialog dialog, String title, Module module) {
        super(dialog, title);
        this.init(module);
    }

    public ModuleExportDialog(JFrame frame, String title, Module module) {
        super(frame, title);
        this.init(module);
    }

    private void updateModuleInfo() {
        if (this.module != null) {
            String moduleName = this.module.getName();
            this.manifest = ModulePackager.getModuleManifest(this.module.getCompletePath());
            String moduleVersion = "";
            String moduleDesc = "";
            if (this.manifest != null) {
                Attributes attributes = this.manifest.getMainAttributes();
                moduleVersion = attributes.getValue("Module-Version");
                moduleDesc = attributes.getValue("Module-Description");
            }
            this.nameTextField.setText(moduleName);
            this.versionTextField.setText(moduleVersion);
            this.descTextField.setText(moduleDesc);
        }
    }

    private void init(Module inModule) {
        this.module = inModule;
        this.content = new JPanel(new GridBagLayout());
        this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
        JComboBox<String> modulesComboBox = new JComboBox<String>();
        modulesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    String moduleName = (String)e.getItem();
                    DataCollection dc = (DataCollection)CollectionFactoryUtils.getDatabases().get(moduleName);
                    ModuleExportDialog.this.module = (Module)dc;
                    ModuleExportDialog.this.updateModuleInfo();
                }
                catch (Exception e1) {
                    throw ExceptionRegistry.translateException((Throwable)e1);
                }
            }
        });
        for (DataCollection module : CollectionFactoryUtils.getDatabases()) {
            modulesComboBox.addItem(module.getName());
        }
        if (inModule != null) {
            modulesComboBox.setSelectedItem(inModule.getName());
        }
        JButton browseButton = new JButton("...");
        this.pathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ModuleExportDialog.this.updateOKButton();
            }
        });
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileFilter(new BMDFileFilter());
                int res = chooser.showSaveDialog((Component)Application.getApplicationFrame());
                if (res == 0) {
                    ModuleExportDialog.this.selectedFile = chooser.getSelectedFile();
                    if (!ModuleExportDialog.this.selectedFile.getName().toLowerCase().endsWith(".bmd")) {
                        ModuleExportDialog.this.selectedFile = new File(ModuleExportDialog.this.selectedFile.getPath() + ".bmd");
                    }
                    ModuleExportDialog.this.pathTextField.setText(ModuleExportDialog.this.selectedFile.getPath());
                    ModuleExportDialog.this.updateOKButton();
                }
            }
        });
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ModuleExportDialog.this.updateOKButton();
            }
        });
        this.updateOKButton();
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("SELECT_DATABASE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.content.add(modulesComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("NEW_NAME")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.nameTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("VERSION")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.versionTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DESCRIPTION")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.descTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("FILE_LOCATION")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.pathTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)browseButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.setContent(this.content);
    }

    private void updateOKButton() {
        String moduleName = this.nameTextField.getText();
        boolean correctModuleName = moduleName != null && moduleName.length() > 0;
        String filename = this.pathTextField.getText();
        boolean correctFileName = filename != null && filename.length() > 0;
        this.okButton.setEnabled(correctModuleName && correctFileName);
    }

    protected void okPressed() {
        super.okPressed();
        final FunctionJobControl jobControl = new FunctionJobControl(null);
        final Logger cat = Logger.getLogger(ModulePackager.class.getName());
        final String exportingStr = BioUMLApplication.getMessageBundle().getResourceString("EXPORTING");
        final StatusInfoDialog infoDialog = new StatusInfoDialog((JFrame)Application.getApplicationFrame(), exportingStr, cat, (JobControl)jobControl);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    infoDialog.setInfo(exportingStr + "...");
                    ModulePackager.exportModule((DataCollection)ModuleExportDialog.this.module, ModuleExportDialog.this.nameTextField.getText(), ModuleExportDialog.this.versionTextField.getText(), ModuleExportDialog.this.descTextField.getText(), ModuleExportDialog.this.pathTextField.getText(), jobControl, null);
                }
                catch (Throwable t) {
                    cat.log(Level.SEVERE, t.getMessage());
                    infoDialog.fails();
                    return;
                }
                infoDialog.success();
            }
        };
        infoDialog.startProcess(thread);
    }
}

