/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.model.util.ModulePackager;
import biouml.workbench.BioUMLApplication;
import java.io.File;
import java.text.MessageFormat;
import java.util.jar.JarFile;
import javax.swing.filechooser.FileFilter;

public class BMDFileFilter
extends FileFilter {
    public static final String BMD_EXTENTION = ".bmd";
    public static final String ZIP_EXTENTION = ".zip";
    public static final String JAR_EXTENTION = ".jar";
    private static final String[] exts = new String[]{".bmd", ".zip", ".jar"};

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (f.isFile()) {
            boolean accept = false;
            for (String ext : exts) {
                if (!f.getName().toLowerCase().endsWith(ext)) continue;
                try {
                    JarFile jarFile = new JarFile(f);
                    if (ModulePackager.getModuleAttribute(jarFile, "Module-Name") == null) continue;
                    accept = true;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return accept;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("BMD_FILE_DESCRIPTION"), exts);
    }
}

