/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.module;

import biouml.workbench.BioUMLApplication;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.beans.BeanInfoEx;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.PropertyDescriptorEx;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.swing.table.DefaultRowModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import com.developmentontheedge.log.PatternFormatter;
import com.developmentontheedge.log.TextPaneAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListener;
import ru.biosoft.jobcontrol.JobControlListenerAdapter;
import ru.biosoft.util.TextUtil;

public abstract class AbstractLoadPane
extends JPanel {
    public static final String ROOT_DC_NAME = "databases";
    protected JComboBox<String> serverURL;
    protected JTextField username;
    protected JPasswordField password;
    protected boolean useAuth = false;
    protected TabularPropertyInspector databasesPane;
    protected JButton findModulesButton;
    protected JButton getInfoButton;
    protected JButton loadButton;
    protected DatabaseLink selectedLink;
    protected TextPaneAppender appender;
    protected JProgressBar progressBar = new JProgressBar();
    protected List<DatabaseLink> databaseLinks = new ArrayList<DatabaseLink>();
    protected String helpTopic;
    protected final LocalRepository databases = (LocalRepository)CollectionFactoryUtils.getDatabases();
    protected static final MessageBundle resources = BioUMLApplication.getMessageBundle();
    protected static final Logger log = Logger.getLogger(AbstractLoadPane.class.getName());
    private static final String[] CATEGORY_LIST = new String[]{"biouml.diagram", "biouml.workbench", "biouml.plugins"};

    protected abstract List<String> getServers();

    protected abstract int loadModule(String var1, String var2, FunctionJobControl var3);

    protected abstract String getDBInfo(DatabaseLink var1);

    protected abstract List<DatabaseLink> getDatabaseLinks(String var1, String var2, String var3) throws Exception;

    protected abstract void registerServer(String var1);

    protected AbstractLoadPane(String helpTopic, boolean useAuth, String initMessage) {
        List<String> list;
        this.useAuth = useAuth;
        this.helpTopic = helpTopic;
        this.setLayout(new BorderLayout());
        this.username = new JTextField();
        this.password = new JPasswordField();
        try {
            list = this.getServers();
            if (list.isEmpty()) {
                list = Collections.singletonList("(No servers available)");
            }
        }
        catch (Exception e2) {
            log.log(Level.SEVERE, e2.getMessage(), ExceptionRegistry.log((Throwable)e2));
            list = Collections.singletonList("(Servers cannot be loaded; check application log)");
        }
        this.serverURL = new JComboBox<String>(new Vector<String>(list));
        this.serverURL.setEditable(true);
        this.databasesPane = new TabularPropertyInspector();
        this.databasesPane.setPreferredSize(new Dimension(450, 50));
        this.databasesPane.getTable().setSelectionMode(0);
        this.databasesPane.addListSelectionListener(event -> {
            if (event.getFirstIndex() != -1) {
                this.selectedLink = (DatabaseLink)this.databasesPane.getModelOfSelectedRow();
                this.getInfoButton.setEnabled(true);
            } else {
                this.selectedLink = null;
                this.getInfoButton.setEnabled(false);
            }
        });
        JScrollPane databasesScrollPane = new JScrollPane((Component)this.databasesPane, 20, 31);
        this.findModulesButton = new JButton(resources.getResourceString("LOAD_DATABASE_DIALOG_FIND"));
        this.findModulesButton.addActionListener(e -> this.fillModuleNames());
        this.getInfoButton = new JButton(resources.getResourceString("LOAD_DATABASE_DIALOG_DBINFO"));
        this.getInfoButton.setEnabled(false);
        this.getInfoButton.addActionListener(e -> {
            String dbInfo = this.getDBInfo(this.selectedLink);
            DBInfoDialog infoDialog = new DBInfoDialog((JFrame)Application.getApplicationFrame(), dbInfo);
            infoDialog.doModal();
        });
        this.loadButton = new JButton(resources.getResourceString("LOAD_DATABASE_DIALOG_LOAD"));
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(e -> this.okPressed());
        JPanel fields = new JPanel(new GridBagLayout());
        this.add((Component)fields, "Center");
        fields.setBorder(new EmptyBorder(10, 10, 10, 10));
        if (useAuth) {
            fields.add((Component)new JLabel(resources.getResourceString("LOAD_DATABASE_USERNAME")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            fields.add((Component)this.username, new GridBagConstraints(1, 0, 1, 1, 3.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            fields.add((Component)new JLabel(resources.getResourceString("LOAD_DATABASE_PASSWORD")), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            fields.add((Component)this.password, new GridBagConstraints(3, 0, 1, 1, 3.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            JButton updateServers = new JButton("Update servers");
            fields.add((Component)updateServers, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            updateServers.addActionListener(e -> {
                try {
                    this.serverURL.setModel(new DefaultComboBoxModel<String>(new Vector<String>(this.getServers())));
                }
                catch (Exception ex) {
                    ApplicationUtils.errorBox((Throwable)ex);
                    return;
                }
            });
        }
        fields.add((Component)new JLabel(resources.getResourceString("LOAD_DATABASE_DIALOG_SERVER")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        fields.add(this.serverURL, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        fields.add((Component)new JLabel(resources.getResourceString("LOAD_DATABASES_TABLE_TITLE")), new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        fields.add((Component)databasesScrollPane, new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.findModulesButton);
        buttons.add(this.getInfoButton);
        buttons.add(this.loadButton);
        fields.add((Component)buttons, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.progressBar.setMaximum(100);
        fields.add((Component)this.progressBar, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        fields.add((Component)new JLabel(resources.getResourceString("LOAD_DATABASE_DIALOG_INFO")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.initAppender("LOAD_DATABASE_DIALOG_INFO", initMessage);
        fields.add((Component)this.appender.getLogTextPanel(), new GridBagConstraints(0, 7, 5, 2, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.serverURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AbstractLoadPane.this.validateValues();
            }
        });
        this.serverURL.setSelectedIndex(0);
    }

    protected boolean canLoad() {
        if (TextUtil.isEmpty((String)this.getSelectedUrl())) {
            return false;
        }
        return this.databaseLinks.stream().anyMatch(DatabaseLink::isShouldBeInstalled);
    }

    protected void validateValues() {
        this.loadButton.setEnabled(this.canLoad());
        String url = this.getSelectedUrl();
        this.findModulesButton.setEnabled(url != null && !url.isEmpty());
    }

    public void loadIfDatabasesChecked() {
        if (this.databaseLinks.stream().anyMatch(DatabaseLink::isShouldBeInstalled)) {
            String title = resources.getResourceString("LOAD_DATABASES_TABLE_INSTALL_SELECTED_TITLE");
            String message = resources.getResourceString("LOAD_DATABASES_TABLE_INSTALL_SELECTED_MESSAGE");
            int answer = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message, title, 0);
            if (answer == 0) {
                this.okPressed();
            }
        }
    }

    public void okPressed() {
        this.loadButton.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                int installedCount = 0;
                int toInstall = 0;
                for (DatabaseLink databaseLink : AbstractLoadPane.this.databaseLinks) {
                    if (!databaseLink.isShouldBeInstalled()) continue;
                    ++toInstall;
                }
                InstallDBJobControl jc = new InstallDBJobControl(log, (JobControlListener)new JobControlListenerAdapter(){

                    public void valueChanged(JobControlEvent event) {
                        AbstractLoadPane.this.progressBar.setValue(event.getPreparedness());
                    }
                }, toInstall);
                for (DatabaseLink dLink : AbstractLoadPane.this.databaseLinks) {
                    if (!dLink.isShouldBeInstalled()) continue;
                    String serverName = dLink.getServerName();
                    String clientName = dLink.getClientName();
                    if (serverName != null && serverName.length() > 0 && clientName != null && clientName.length() > 0) {
                        installedCount += AbstractLoadPane.this.loadModule(serverName, clientName, jc);
                    }
                    dLink.setShouldBeInstalled(false);
                    jc.nextSubprocess();
                }
                String string = AbstractLoadPane.this.getSelectedUrl();
                AbstractLoadPane.this.registerServer(string);
                if (AbstractLoadPane.this.findServerAddressComboItem(string) < 0) {
                    AbstractLoadPane.this.serverURL.addItem(string);
                    int idx = AbstractLoadPane.this.findServerAddressComboItem(string);
                    AbstractLoadPane.this.serverURL.setSelectedIndex(idx);
                }
                log.info("" + installedCount + " databases were installed");
                AbstractLoadPane.this.loadButton.setEnabled(true);
            }
        }.start();
    }

    protected void fillModuleNames() {
        this.findModulesButton.setEnabled(false);
        final PropertyChangeListener listener = evt -> this.validateValues();
        Thread thread = new Thread(){

            @Override
            public void run() {
                List<DatabaseLink> newLinks = null;
                try {
                    newLinks = AbstractLoadPane.this.getDatabaseLinks(AbstractLoadPane.this.getSelectedUrl(), AbstractLoadPane.this.username.getText(), new String(AbstractLoadPane.this.password.getPassword()));
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Unable to fetch database links: " + ExceptionRegistry.log((Throwable)t));
                }
                if (newLinks != null) {
                    AbstractLoadPane.this.databaseLinks = newLinks;
                    Collections.sort(AbstractLoadPane.this.databaseLinks);
                    for (DatabaseLink link : AbstractLoadPane.this.databaseLinks) {
                        link.addPropertyChangeListener(listener);
                    }
                } else {
                    AbstractLoadPane.this.databaseLinks.clear();
                }
                if (AbstractLoadPane.this.databaseLinks.size() > 0) {
                    AbstractLoadPane.this.databasesPane.explore((Object[])AbstractLoadPane.this.databaseLinks.toArray(new DatabaseLink[AbstractLoadPane.this.databaseLinks.size()]));
                    log.info("Databases are loaded successfully.");
                    log.info("Please check install checkboxes on databases you want to install.");
                    log.info("Press '" + resources.getResourceString("LOAD_DATABASE_DIALOG_LOAD") + "' button when finished.");
                } else {
                    AbstractLoadPane.this.databasesPane.explore((RowModel)new DefaultRowModel(), (Object)new DatabaseLink(""), 0);
                    log.warning("No databases found. Please check the URL.");
                }
                AbstractLoadPane.this.findModulesButton.setEnabled(true);
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    protected void initAppender(String title, String initialMessage) {
        this.appender = new TextPaneAppender((Formatter)new PatternFormatter("[%4$-7s] :  %5$s%n"), title);
        this.appender.setLevel(Level.INFO);
        this.appender.addToCategories(CATEGORY_LIST);
        this.appender.getLogTextPanel().setPreferredSize(new Dimension(450, 200));
        if (initialMessage != null) {
            this.appender.getLogTextPanel().setText(initialMessage);
        }
    }

    protected String message(String key, Object[] params) {
        String message = resources.getString(key);
        return MessageFormat.format(message, params);
    }

    protected int findServerAddressComboItem(String address) {
        for (int i = 0; i < this.serverURL.getItemCount(); ++i) {
            if (!address.equalsIgnoreCase(this.serverURL.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    protected String getSelectedUrl() {
        Object obj = this.serverURL.getSelectedItem();
        if (obj == null) {
            return null;
        }
        String result = obj.toString().trim();
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public static class DBInfoDialog
    extends OkCancelDialog {
        public DBInfoDialog(JFrame parent, String text) {
            super(parent, "Database info");
            this.init(text);
        }

        protected void init(String text) {
            this.cancelButton.setVisible(false);
            this.setPreferredSize(new Dimension(250, 600));
            JTextPane content = new JTextPane();
            content.setContentType("text/html");
            content.setText(this.getHTMLText(text));
            content.setEditable(false);
            this.setContent(content);
        }

        private String getHTMLText(String text) {
            String result = "<b>" + text;
            result = result.replaceAll("\n", "<br><b>");
            result = result.replaceAll(":", ":</b>");
            result = result.replaceAll("\t", "&nbsp;&nbsp;");
            return result;
        }
    }

    public static class DatabaseLinkBeanInfo
    extends BeanInfoEx {
        public DatabaseLinkBeanInfo() {
            this(DatabaseLink.class, resources.getClass().getName());
        }

        public DatabaseLinkBeanInfo(Class<? extends DatabaseLink> type, String name) {
            super(type, name);
            this.beanDescriptor.setDisplayName("Database link");
            this.beanDescriptor.setShortDescription("Database link");
        }

        public void initProperties() throws Exception {
            PropertyDescriptorEx pde = new PropertyDescriptorEx("serverName", this.beanClass, "getServerName", null);
            this.add((PropertyDescriptor)pde, resources.getResourceString("LOAD_DATABASE_DIALOG_SERVER_NAME"), resources.getResourceString("LOAD_DATABASE_DIALOG_SERVER_NAME"));
            pde = new PropertyDescriptorEx("clientName", this.beanClass, "getClientName", "setClientName");
            this.add((PropertyDescriptor)pde, resources.getResourceString("LOAD_DATABASE_DIALOG_CLIENT_NAME"), resources.getResourceString("LOAD_DATABASE_DIALOG_CLIENT_NAME"));
            pde = new PropertyDescriptorEx("availability", this.beanClass, "getAvailability", null);
            this.add((PropertyDescriptor)pde, resources.getResourceString("LOAD_DATABASE_DIALOG_AVAILABILITY"), resources.getResourceString("LOAD_DATABASE_DIALOG_AVAILABILITY"));
            pde = new PropertyDescriptorEx("accessType", this.beanClass, "getAccessType", null);
            this.add((PropertyDescriptor)pde, resources.getResourceString("LOAD_DATABASE_DIALOG_ACCESSTYPE"), resources.getResourceString("LOAD_DATABASE_DIALOG_ACCESSTYPE"));
            pde = new PropertyDescriptorEx("shouldBeInstalled", this.beanClass, "isShouldBeInstalled", "setShouldBeInstalled");
            this.add((PropertyDescriptor)pde, resources.getResourceString("LOAD_DATABASE_DIALOG_INSTALL"), resources.getResourceString("LOAD_DATABASE_DIALOG_INSTALL"));
        }
    }

    public static class DatabaseLink
    extends Option
    implements Comparable<DatabaseLink> {
        private String serverName;
        private String clientName;
        private boolean shouldBeInstalled;
        private String availability;
        private String accessType;
        private Properties properties;

        public DatabaseLink(String serverName) {
            this.clientName = this.serverName = serverName;
            this.shouldBeInstalled = false;
        }

        public Properties getProperties() {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            return this.properties;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            String oldValue = this.clientName;
            this.clientName = clientName;
            this.firePropertyChange("clientName", oldValue, clientName);
        }

        public boolean isShouldBeInstalled() {
            return this.shouldBeInstalled;
        }

        public void setShouldBeInstalled(boolean shouldBeInstalled) {
            boolean oldValue = this.shouldBeInstalled;
            this.shouldBeInstalled = shouldBeInstalled;
            this.firePropertyChange("shoudBeInstalled", oldValue, shouldBeInstalled);
        }

        public String getAvailability() {
            return this.availability;
        }

        public void setAvailability(String availability) {
            this.availability = availability;
        }

        public String getAccessType() {
            return this.accessType;
        }

        public void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public int compareTo(DatabaseLink obj) {
            return this.serverName.compareTo(obj.serverName);
        }
    }

    public static class InstallDBJobControl
    extends FunctionJobControl {
        private int current;
        private final int total;

        public InstallDBJobControl(Logger cat, JobControlListener listener, int total) {
            super(cat, listener);
            this.total = total;
        }

        public void setPreparedness(int percent) {
            super.setPreparedness((percent + this.current * 100) / this.total);
        }

        public void nextSubprocess() {
            ++this.current;
            this.setPreparedness(0);
        }
    }
}

