/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.htmlgen;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.model.util.DiagramXmlWriter;
import biouml.model.util.ImageGenerator;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.htmlgen.XSLFileFilter;
import biouml.workbench.module.StatusInfoDialog;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.gui.Document;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;

public class GenerateHTMLDialog
extends OkCancelDialog {
    protected JPanel content;
    protected Module module;
    protected Diagram diagram;
    public static final String TEMPLATES_FOLDER_NAME = "templates";
    JComboBox<String> modulesComboBox = new JComboBox();
    JComboBox<String> diagramsComboBox = new JComboBox();
    JLabel diagramsLabal = new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM"));
    protected JTextField outputFolderTextField = new JTextField(20);
    protected JTextField templateTextField = new JTextField(20);
    protected JComboBox<String> scopeComboBox = new JComboBox();
    protected static final Logger cat = Logger.getLogger(GenerateHTMLDialog.class.getName());

    public GenerateHTMLDialog(JDialog dialog, String title, Module module, Diagram diagram) {
        super(dialog, title);
        this.init(module, diagram);
    }

    public GenerateHTMLDialog(JFrame frame, String title, Module module, Diagram diagram) {
        super(frame, title);
        this.init(module, diagram);
    }

    protected void updateOKButton() {
        this.okButton.setEnabled(this.outputFolderTextField.getText().length() > 0 && this.templateTextField.getText().length() > 0);
    }

    private void init(Module module, Diagram diagram) {
        this.module = module;
        this.diagram = diagram;
        JButton templateBrowseButton = new JButton("...");
        JButton outputFolderBrowseButton = new JButton("...");
        this.content = new JPanel(new GridBagLayout());
        this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
        outputFolderBrowseButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GenerateHTMLDialog.this.updateOKButton();
            }
        });
        outputFolderBrowseButton.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(BioUMLApplication.getMessageBundle().getResourceString("SELECT_OUTPUT_FOLDER"));
            int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
            if (res == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.outputFolderTextField.setText(selectedFile.getPath());
                this.updateOKButton();
            }
        });
        templateBrowseButton.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(((LocalRepository)CollectionFactoryUtils.getDatabases()).getRootDirectory(), TEMPLATES_FOLDER_NAME));
            chooser.setFileFilter(new XSLFileFilter());
            chooser.setMultiSelectionEnabled(false);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogTitle(BioUMLApplication.getMessageBundle().getResourceString("SELECT_TEMPLATE"));
            int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
            if (res == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.templateTextField.setText(selectedFile.getPath());
                this.updateOKButton();
            }
        });
        templateBrowseButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GenerateHTMLDialog.this.updateOKButton();
            }
        });
        for (DataElement de : CollectionFactoryUtils.getDatabases()) {
            if (!(de instanceof Module)) continue;
            this.modulesComboBox.addItem(de.getName());
        }
        this.scopeComboBox = new JComboBox();
        this.scopeComboBox.addItemListener(e -> {
            String item = (String)e.getItem();
            this.setDiagramsVisible(item.equals(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM")));
        });
        this.scopeComboBox.addItem(BioUMLApplication.getMessageBundle().getResourceString("DATABASE"));
        this.scopeComboBox.addItem(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM"));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("SCOPE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.content.add(this.scopeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DATABASE")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add(this.modulesComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)this.diagramsLabal, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add(this.diagramsComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("OUTPUT_FOLDER")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.outputFolderTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)outputFolderBrowseButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("TEMPLATE")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.content.add((Component)this.templateTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.content.add((Component)templateBrowseButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.setContent(this.content);
        this.diagramsComboBox.addItemListener(e -> {
            if (this.module != null) {
                String diagramName = (String)e.getItem();
                try {
                    this.diagram = this.module.getDiagram(diagramName);
                    System.out.println("levo: GenerateHTMLDialog.itemStateChanged: GenerateHTMLDialog.this.diagram = " + (Object)((Object)this.diagram));
                }
                catch (Exception exc) {
                    cat.log(Level.SEVERE, "Error at getting " + diagramName + " diagram", exc);
                }
            }
        });
        this.modulesComboBox.addItemListener(e -> this.setModule((String)e.getItem()));
        System.out.println("levo: GenerateHTMLDialog.init: module = " + (Object)((Object)module));
        System.out.println("levo: GenerateHTMLDialog.init: diagram = " + (Object)((Object)diagram));
        if (module == null && diagram == null) {
            Document activeDocument = Document.getActiveDocument();
            if (activeDocument instanceof DiagramDocument) {
                this.diagram = ((DiagramDocument)activeDocument).getDiagram();
                this.module = Module.optModule((DataElement)this.diagram);
            } else if (this.modulesComboBox.getItemCount() > 0) {
                this.setModule(this.modulesComboBox.getItemAt(0));
            }
        } else if (module != null) {
            this.modulesComboBox.setSelectedItem(module.getName());
            if (diagram != null) {
                this.diagramsComboBox.setSelectedItem(diagram.getName());
                this.scopeComboBox.setSelectedItem(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM"));
            }
        }
    }

    private void setModule(String moduleName) {
        this.module = (Module)DataElementPath.create((String)"databases").getChildPath(new String[]{moduleName}).getDataElement(Module.class);
        this.updateDiagrams(moduleName);
    }

    private void updateDiagrams(String moduleName) {
        System.out.println("levo: GenerateHTMLDialog.updateDiagrams: moduleName = " + moduleName);
        try {
            DataCollection<Diagram> diagrams = this.module.getDiagrams();
            this.diagramsComboBox.removeAllItems();
            for (Diagram diagram : diagrams) {
                this.diagramsComboBox.addItem(diagram.getName());
            }
        }
        catch (Exception exc) {
            cat.log(Level.SEVERE, "Error at getting module " + moduleName + " diagrams", exc);
        }
    }

    private void setDiagramsVisible(boolean diagramsVisible) {
        this.diagramsLabal.setVisible(diagramsVisible);
        this.diagramsComboBox.setVisible(diagramsVisible);
    }

    protected void okPressed() {
        super.okPressed();
        final FunctionJobControl jobControl = new FunctionJobControl(null);
        final Logger cat = Logger.getLogger(GenerateHTMLDialog.class.getName());
        final String infoStr = BioUMLApplication.getMessageBundle().getResourceString("GENERATING_HTML");
        final StatusInfoDialog infoDialog = new StatusInfoDialog((JFrame)Application.getApplicationFrame(), infoStr, cat, (JobControl)jobControl);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    infoDialog.setInfo(infoStr + "...");
                    GenerateHTMLDialog.this.genHTML(cat, jobControl, GenerateHTMLDialog.this.module, GenerateHTMLDialog.this.diagram);
                }
                catch (Throwable t) {
                    cat.log(Level.SEVERE, t.getMessage());
                    infoDialog.fails();
                    return;
                }
                infoDialog.success();
            }
        };
        infoDialog.startProcess(thread);
    }

    private void genHTML(Logger cat, FunctionJobControl jobControl, Module module, Diagram diagram) throws Exception {
        if (jobControl != null) {
            jobControl.functionStarted();
        }
        try {
            String outputFolderPath = this.outputFolderTextField.getText();
            File outputFolder = new File(outputFolderPath);
            if (!outputFolder.exists() && !outputFolder.mkdir()) {
                throw new Exception("Failed to create output folder '" + outputFolderPath + "'.");
            }
            File templateFile = new File(this.templateTextField.getText());
            if (this.scopeComboBox.getSelectedItem().equals(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM"))) {
                GenerateHTMLDialog.genHTML(diagram, outputFolder, templateFile, cat);
            } else if (this.scopeComboBox.getSelectedItem().equals(BioUMLApplication.getMessageBundle().getResourceString("DATABASE"))) {
                String generatingHTMLForModuleMessage = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("GENERATING_HTML_FOR_DATABASE"), module.getName());
                cat.info(generatingHTMLForModuleMessage);
                int count = 0;
                DataCollection<Diagram> diagrams = module.getDiagrams();
                for (Diagram d : diagrams) {
                    GenerateHTMLDialog.genHTML(d, outputFolder, templateFile, cat);
                    ++count;
                    if (jobControl == null) continue;
                    jobControl.setPreparedness(100 * count / diagrams.getSize());
                }
            }
            String message = BioUMLApplication.getMessageBundle().getResourceString("HTML_GENERATED_SUCCESSFULLY");
            cat.info(message);
            if (jobControl != null) {
                jobControl.functionFinished(message);
            }
        }
        catch (Exception e) {
            if (jobControl != null) {
                jobControl.functionTerminatedByError((Throwable)e);
            }
            throw e;
        }
    }

    public static void genHTML(Diagram diagram, File outputFolder, File templateFile, Logger cat) throws Exception {
        String digramName = diagram.getName();
        File outputDiagramFile = new File(outputFolder, digramName + ".html");
        File outputDiagramImageFile = new File(outputFolder, digramName + ".png");
        String message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("GENERATING_HTML_FOR_DIAGRAM"), digramName);
        cat.info(message);
        BufferedImage image = ImageGenerator.generateDiagramImage(diagram);
        try (FileOutputStream out = new FileOutputStream(outputDiagramImageFile);){
            ImageGenerator.encodeImage(image, "PNG", out);
        }
        message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("CREATING_IMAGE_SUCCESS"), outputDiagramImageFile.getName());
        cat.info(message);
        StreamSource streamSource = new StreamSource(templateFile);
        try (FileOutputStream fos = new FileOutputStream(outputDiagramFile);){
            DiagramXmlWriter xmlWriter = new DiagramXmlWriter(fos);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            Rectangle rect = diagram.getView().getBounds();
            transformer.setParameter("x_offset", Integer.toString((int)rect.getX()));
            transformer.setParameter("y_offset", Integer.toString((int)rect.getY()));
            String outputFolderPath = outputFolder.getCanonicalPath();
            if (!outputFolderPath.endsWith(File.separator)) {
                outputFolderPath = outputFolderPath + File.separator;
            }
            transformer.setParameter("path", outputFolderPath);
            xmlWriter.write(diagram, transformer);
        }
        message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("APPLAYING_TEMPLATE"), outputDiagramImageFile.getName());
        cat.info(message);
    }

    public boolean doModal() {
        this.setDiagramsVisible(true);
        this.pack();
        ApplicationUtils.moveToCenter((Component)((Object)this));
        this.setDiagramsVisible(this.scopeComboBox.getSelectedItem().equals(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM")));
        this.show();
        this.dispose();
        return this.result;
    }
}

