/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch.actions;

import biouml.workbench.graphsearch.GraphSearchViewPart;
import biouml.workbench.graphsearch.QueryEngine;
import biouml.workbench.graphsearch.QueryEngineRegistry;
import biouml.workbench.graphsearch.SearchElement;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlListener;

public class SearchAction
extends AbstractAction {
    protected Logger log = Logger.getLogger(SearchAction.class.getName());
    public static final String KEY = "Search action";
    public static final String SEARCH_PANE = "SearchPane";

    public SearchAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        GraphSearchViewPart searchPane = (GraphSearchViewPart)((Object)this.getValue(SEARCH_PANE));
        if (searchPane == null) {
            this.log.log(Level.SEVERE, "Search view part is undefined");
            return;
        }
        String searchType = searchPane.getOptions().getSearchType();
        TargetOptions target = searchPane.getOptions().getTargetOptions();
        if (!target.collections().anyMatch(cr -> !QueryEngineRegistry.getQueryEngines(cr, searchType).isEmpty())) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "There is no available search engine for this options");
            this.log.log(Level.SEVERE, "Can not find QueryEngine for this options");
            return;
        }
        new SearchThread(searchPane, searchType).start();
    }

    public class SearchThread
    extends Thread {
        protected GraphSearchViewPart searchPane;
        protected String searchType;

        public SearchThread(GraphSearchViewPart searchPane, String searchType) {
            this.searchPane = searchPane;
            this.searchType = searchType;
        }

        @Override
        public void run() {
            try {
                FunctionJobControl jobControl = new FunctionJobControl(null);
                ApplicationFrame application = Application.getApplicationFrame();
                if (application != null) {
                    jobControl.addListener((JobControlListener)application.getStatusBar());
                }
                jobControl.functionStarted();
                TargetOptions target = this.searchPane.getOptions().getTargetOptions();
                for (TargetOptions.CollectionRecord collection : target.collections()) {
                    List<QueryEngine> engines = QueryEngineRegistry.getQueryEngines(collection, this.searchType);
                    for (QueryEngine queryEngine : engines) {
                        SearchElement[] result = null;
                        if ("neighbours".equals(this.searchType)) {
                            result = queryEngine.searchLinked(this.searchPane.getInputElements(), this.searchPane.getOptions().getQueryOptions(), this.searchPane.getOptions().getTargetOptions(), (JobControl)jobControl);
                        } else if ("path".equals(this.searchType)) {
                            result = queryEngine.searchPath(this.searchPane.getInputElements(), this.searchPane.getOptions().getQueryOptions(), this.searchPane.getOptions().getTargetOptions(), (JobControl)jobControl);
                        } else if ("set".equals(this.searchType)) {
                            result = queryEngine.searchSet(this.searchPane.getInputElements(), this.searchPane.getOptions().getQueryOptions(), this.searchPane.getOptions().getTargetOptions(), (JobControl)jobControl);
                        }
                        this.searchPane.addOutputElements(result);
                    }
                }
                jobControl.functionFinished();
            }
            catch (Exception e) {
                SearchAction.this.log.log(Level.SEVERE, "Search error", e);
            }
        }
    }
}

