/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch.actions;

import biouml.model.Diagram;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.type.DiagramInfo;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.graphsearch.GraphSearchViewPart;
import biouml.workbench.graphsearch.MessageBundle;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.GUI;

public class CreateResultDiagramAction
extends AbstractAction {
    protected static final Logger log = Logger.getLogger(CreateResultDiagramAction.class.getName());
    public static final String KEY = "Create diagram action";
    public static final String SEARCH_PANE = "SearchPane";
    protected MessageBundle messages = new MessageBundle();

    public CreateResultDiagramAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        GraphSearchViewPart searchPane = (GraphSearchViewPart)((Object)this.getValue(SEARCH_PANE));
        if (searchPane == null) {
            log.log(Level.SEVERE, "Search view part is undefined");
            return;
        }
        DiagramDocument document = CreateResultDiagramAction.createNewDiagramDocument();
        searchPane.addDocumentToTargetSet(document);
    }

    public static DiagramDocument createNewDiagramDocument() {
        PathwaySimulationDiagramType diagramType = new PathwaySimulationDiagramType();
        try {
            Diagram diagram = new Diagram(null, new DiagramInfo(null, CreateResultDiagramAction.getNewDiagramName(GUI.getManager().getDocuments())), diagramType);
            DiagramDocument diagramDocument = new DiagramDocument(diagram);
            GUI.getManager().addDocument((Document)diagramDocument);
            return diagramDocument;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create new diagram", e);
            return null;
        }
    }

    protected static String getNewDiagramName(Collection<Document> documents) {
        boolean exists;
        String base = "New diagram ";
        int num = 0;
        String name = null;
        do {
            name = base + ++num;
        } while (exists = StreamEx.of(documents).map(Document::getModel).select(DataElement.class).map(DataElement::getName).has((Object)name));
        return name;
    }
}

