/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch.actions;

import biouml.model.Diagram;
import biouml.model.util.AddElementsUtils;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.graphsearch.GraphSearchViewPart;
import biouml.workbench.graphsearch.MessageBundle;
import biouml.workbench.graphsearch.actions.CreateResultDiagramAction;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import ru.biosoft.gui.Document;

public class AddElementsToDiagramAction
extends AbstractAction {
    protected Logger log = Logger.getLogger(AddElementsToDiagramAction.class.getName());
    public static final String KEY = "Add elements action";
    public static final String SEARCH_PANE = "SearchPane";
    protected MessageBundle messages = new MessageBundle();

    public AddElementsToDiagramAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        GraphSearchViewPart searchPane = (GraphSearchViewPart)((Object)this.getValue(SEARCH_PANE));
        if (searchPane == null) {
            this.log.log(Level.SEVERE, "Search view part is undefined");
            return;
        }
        DiagramDocument document = null;
        Document currentDocument = Document.getActiveDocument();
        if (!(currentDocument instanceof DiagramDocument)) {
            int status = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), this.messages.getResourceString("CONFIRM_CREATE_DIAGRAM"), "", 0);
            if (status == 0) {
                document = CreateResultDiagramAction.createNewDiagramDocument();
            }
        } else if (searchPane.isDocumentInTargetSet((DiagramDocument)currentDocument)) {
            document = (DiagramDocument)currentDocument;
        } else {
            int messageType = 3;
            Object[] options = new String[]{"Use current", "New diagram", "Cancel"};
            int code = JOptionPane.showOptionDialog((Component)Application.getApplicationFrame(), this.messages.getResourceString("CONFIRM_USE_CURRENT_DIAGRAM"), "", 0, messageType, null, options, "New diagram");
            if (code == 0) {
                document = (DiagramDocument)currentDocument;
                searchPane.addDocumentToTargetSet(document);
            } else if (code == 1) {
                document = CreateResultDiagramAction.createNewDiagramDocument();
            }
        }
        if (document != null) {
            Diagram diagram = (Diagram)((Object)document.getModel());
            try {
                AddElementsUtils.addElements(diagram, searchPane.getAddElements(), null);
            }
            catch (Exception e) {
                String message = "Error adding elements: " + e.getMessage();
                this.log.log(Level.SEVERE, message);
                ApplicationUtils.errorBox((String)"Error", (String)message);
            }
            document.update();
        }
    }
}

