/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch.actions;

import biouml.model.DiagramElement;
import biouml.model.Module;
import biouml.model.Node;
import biouml.standard.type.Base;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.graphsearch.GraphSearchViewPart;
import biouml.workbench.graphsearch.SearchElement;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import one.util.streamex.StreamEx;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.access.core.DataElementPath;

public class AddDiagramElementAction
extends AbstractAction {
    protected Logger log = Logger.getLogger(AddDiagramElementAction.class.getName());
    public static final String KEY = "Add diagram element";
    public static final String DIAGRAM_DOCUMENT = "DiagramDocument";
    public static final String SEARCH_PANE = "SearchPane";

    public AddDiagramElementAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DiagramDocument document = (DiagramDocument)this.getValue(DIAGRAM_DOCUMENT);
        if (document == null) {
            this.log.log(Level.SEVERE, "Diagram is undefined");
            return;
        }
        GraphSearchViewPart searchPane = (GraphSearchViewPart)((Object)this.getValue(SEARCH_PANE));
        if (searchPane == null) {
            this.log.log(Level.SEVERE, "Search view part is undefined");
            return;
        }
        Object[] selectedModels = document.getDiagramViewPane().getSelectionManager().getSelectedModels();
        if (selectedModels != null) {
            String species = searchPane.getOptions().getSpecies().getLatinName();
            List kernels = StreamEx.of((Object[])selectedModels).select(Node.class).map(DiagramElement::getKernel).map(kernel -> {
                DynamicProperty dp = kernel.getAttributes().getProperty("originalPath");
                if (dp != null) {
                    return (Base)DataElementPath.create((String)((String)dp.getValue())).getDataElement(Base.class);
                }
                return kernel;
            }).toList();
            DataElementPath modulePath = StreamEx.of((Collection)kernels).findFirst().map(Module::optModulePath).orElse(null);
            StreamEx.of((Collection)kernels).forEach(k -> {
                SearchElement se = new SearchElement((Base)k);
                se.setUse(true);
                se.setRelationType(species);
                searchPane.addInputElement(se);
            });
            if (modulePath != null) {
                TargetOptions targetOptions = searchPane.getOptions().getTargetOptions();
                Optional ocr = targetOptions.collections().findFirst(cr -> cr.getPath().equals((Object)modulePath));
                if (ocr.isPresent()) {
                    ((TargetOptions.CollectionRecord)ocr.get()).setUse(true);
                } else {
                    targetOptions.setCollections((TargetOptions.CollectionRecord[])targetOptions.collections().append((Object)new TargetOptions.CollectionRecord(modulePath, true)).toArray(TargetOptions.CollectionRecord[]::new));
                }
                searchPane.invalidateOptions();
            }
        }
    }
}

