/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch;

import biouml.workbench.graphsearch.QueryEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.eclipse.core.runtime.IConfigurationElement;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.util.ExtensionRegistrySupport;

public class QueryEngineRegistry
extends ExtensionRegistrySupport<QueryEngineInfo> {
    public static final String NAME_ATTR = "name";
    public static final String CLASS_ATTR = "class";
    public static final String COLLECTION_ELEMENT = "collection";
    public static final String COLLECTION_PATH_ATTR = "path";
    private static final QueryEngineRegistry instance = new QueryEngineRegistry();

    private QueryEngineRegistry() {
        super("biouml.workbench.queryEngine", NAME_ATTR);
    }

    protected QueryEngineInfo loadElement(IConfigurationElement element, String name) throws Exception {
        QueryEngine queryEngine = (QueryEngine)this.getClassAttribute(element, CLASS_ATTR, QueryEngine.class).newInstance();
        QueryEngineInfo queryEngineInfo = new QueryEngineInfo(name, queryEngine);
        IConfigurationElement[] collections = element.getChildren(COLLECTION_ELEMENT);
        if (collections != null) {
            for (IConfigurationElement collectionElement : collections) {
                queryEngineInfo.addCollectionPath(this.getStringAttribute(collectionElement, COLLECTION_PATH_ATTR));
            }
        }
        return queryEngineInfo;
    }

    public static QueryEngine lookForQueryEngine(TargetOptions target, String queryType) {
        String bestName = null;
        int priority = 0;
        Iterator iterator = instance.iterator();
        while (iterator.hasNext()) {
            QueryEngineInfo info = (QueryEngineInfo)iterator.next();
            try {
                QueryEngine queryEngine = info.getQueryEngine();
                int p = 0;
                if ("neighbours".equals(queryType)) {
                    p = queryEngine.canSearchLinked(target);
                } else if (COLLECTION_PATH_ATTR.equals(queryType)) {
                    p = queryEngine.canSearchPath(target);
                } else if ("set".equals(queryType)) {
                    p = queryEngine.canSearchSet(target);
                }
                if (p <= priority) continue;
                priority = p;
                bestName = info.getName();
            }
            catch (Exception exception) {}
        }
        if (bestName != null) {
            return ((QueryEngineInfo)instance.getExtension(bestName)).getQueryEngine();
        }
        return null;
    }

    @Nonnull
    public static List<QueryEngine> getQueryEngines(TargetOptions.CollectionRecord cr, String queryType) {
        Object[] names = cr.getQueryEngineNamesStrings();
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        Map<String, QueryEngine> enginesMap = QueryEngineRegistry.lookForQueryEngines(cr, queryType);
        if (enginesMap.size() == 0) {
            return Collections.emptyList();
        }
        return ((StreamEx)StreamEx.of((Object[])names).map(enginesMap::get).nonNull()).toList();
    }

    public static Map<String, QueryEngine> lookForQueryEngines(TargetOptions.CollectionRecord collection) {
        return QueryEngineRegistry.lookForQueryEngines(collection, "");
    }

    public static Map<String, QueryEngine> lookForQueryEngines(TargetOptions.CollectionRecord collection, String queryType) {
        class EngineWithPriority
        implements Comparable<EngineWithPriority> {
            String name;
            QueryEngine engine;
            int priority;

            public EngineWithPriority(String queryType, TargetOptions target, QueryEngine engine) {
                this.name = engine.getName(target);
                this.engine = engine;
                this.priority = this.calcEnginePriority(queryType, target, engine);
            }

            int calcEnginePriority(String queryType, TargetOptions target, QueryEngine engine) {
                switch (queryType) {
                    case "neighbours": {
                        return engine.canSearchLinked(target);
                    }
                    case "path": {
                        return engine.canSearchPath(target);
                    }
                    case "set": {
                        return engine.canSearchSet(target);
                    }
                }
                return IntStream.of(engine.canSearchLinked(target), engine.canSearchPath(target), engine.canSearchSet(target)).max().getAsInt();
            }

            @Override
            public int compareTo(EngineWithPriority o) {
                return this.priority > o.priority ? -1 : (this.priority < o.priority ? 1 : this.name.compareTo(o.name));
            }
        }
        TargetOptions target = new TargetOptions(new TargetOptions.CollectionRecord[]{collection});
        return ((StreamEx)((StreamEx)instance.stream().map(QueryEngineInfo::getQueryEngine).map(queryEngine -> new EngineWithPriority(queryType, target, (QueryEngine)queryEngine)).filter(ewp -> ewp.priority > 0)).sorted()).mapToEntry(e -> e.name, e -> e.engine).toCustomMap(LinkedHashMap::new);
    }

    public static class QueryEngineInfo {
        protected String name;
        protected QueryEngine queryEngine;
        protected List<String> collections;

        public QueryEngineInfo(String name, QueryEngine queryEngine) {
            this.name = name;
            this.queryEngine = queryEngine;
            this.collections = new ArrayList<String>();
        }

        public void addCollectionPath(String path) {
            this.collections.add(path);
        }

        public String getName() {
            return this.name;
        }

        public QueryEngine getQueryEngine() {
            return this.queryEngine;
        }

        public List<String> getCollections() {
            return this.collections;
        }
    }
}

