/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch;

import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.graphsearch.GraphSearchOptions;
import biouml.workbench.graphsearch.MessageBundle;
import biouml.workbench.graphsearch.SearchElement;
import biouml.workbench.graphsearch.actions.AddDiagramElementAction;
import biouml.workbench.graphsearch.actions.AddElementsToDiagramAction;
import biouml.workbench.graphsearch.actions.CleanAction;
import biouml.workbench.graphsearch.actions.CreateResultDiagramAction;
import biouml.workbench.graphsearch.actions.SearchAction;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.PanelInfo;
import com.developmentontheedge.application.PanelManager;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.swing.PropertyInspector;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.ViewPartSupport;

public class GraphSearchViewPart
extends ViewPartSupport {
    protected PanelManager panels;
    protected TabularPropertyInspector elementsTable;
    protected List<SearchElement> elements;
    protected PropertyInspector propertiesPane;
    private GraphSearchOptions graphSearchOptions;
    protected AddDiagramElementAction addDiagramElementAction = null;
    protected SearchAction searchAction = null;
    protected AddElementsToDiagramAction addToDiagramAction = null;
    protected CreateResultDiagramAction createResultDiagramAction = null;
    protected CleanAction cleanAction = null;
    protected Set<DiagramDocument> targetDiagrams = new HashSet<DiagramDocument>();

    public GraphSearchViewPart() {
        this.panels = new PanelManager();
        this.elementsTable = new TabularPropertyInspector();
        PanelInfo leftInfo = new PanelInfo("search elements", (JComponent)this.elementsTable, true, null);
        this.panels.addPanel(leftInfo, null, 0);
        JPanel rightPane = new JPanel(new BorderLayout());
        PanelInfo rightInfo = new PanelInfo("search properties", (JComponent)rightPane, true, null);
        this.panels.addPanel(rightInfo, "search elements", 2, 400);
        this.add((Component)this.panels);
        this.elements = new ArrayList<SearchElement>();
        this.propertiesPane = new PropertyInspector();
        rightPane.add((Component)this.propertiesPane, "Center");
        this.propertiesPane.explore((Object)this.getOptions());
    }

    public boolean canExplore(Object model) {
        return true;
    }

    public void explore(Object model, Document document) {
        super.explore(model, document);
        if (document instanceof DiagramDocument) {
            this.addDiagramElementAction.putValue("DiagramDocument", document);
            this.addDiagramElementAction.setEnabled(true);
        } else {
            this.addDiagramElementAction.setEnabled(false);
        }
    }

    protected void initActions() {
        ActionManager actionManager = Application.getActionManager();
        if (this.addDiagramElementAction == null) {
            this.addDiagramElementAction = new AddDiagramElementAction();
            actionManager.addAction("Add diagram element", (Action)this.addDiagramElementAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.addDiagramElementAction, "Add diagram element");
            this.addDiagramElementAction.putValue("SearchPane", (Object)this);
            this.addDiagramElementAction.setEnabled(false);
        }
        if (this.searchAction == null) {
            this.searchAction = new SearchAction();
            actionManager.addAction("Search action", (Action)this.searchAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.searchAction, "Search action");
            this.searchAction.putValue("SearchPane", (Object)this);
            this.searchAction.setEnabled(false);
        }
        if (this.addToDiagramAction == null) {
            this.addToDiagramAction = new AddElementsToDiagramAction();
            actionManager.addAction("Add elements action", (Action)this.addToDiagramAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.addToDiagramAction, "Add elements action");
            this.addToDiagramAction.putValue("SearchPane", (Object)this);
            this.addToDiagramAction.setEnabled(false);
        }
        if (this.createResultDiagramAction == null) {
            this.createResultDiagramAction = new CreateResultDiagramAction();
            actionManager.addAction("Create diagram action", (Action)this.createResultDiagramAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.createResultDiagramAction, "Create diagram action");
            this.createResultDiagramAction.putValue("SearchPane", (Object)this);
        }
        if (this.cleanAction == null) {
            this.cleanAction = new CleanAction();
            actionManager.addAction("Clean action", (Action)this.cleanAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.cleanAction, "Clean action");
            this.cleanAction.putValue("SearchPane", (Object)this);
        }
    }

    public Action[] getActions() {
        this.initActions();
        return new Action[]{this.addDiagramElementAction, this.searchAction, this.addToDiagramAction, this.createResultDiagramAction, this.cleanAction};
    }

    public GraphSearchOptions getOptions() {
        if (this.graphSearchOptions == null) {
            this.graphSearchOptions = new GraphSearchOptions(CollectionFactoryUtils.getDatabases());
        }
        return this.graphSearchOptions;
    }

    public void invalidateOptions() {
        this.propertiesPane.explore((Object)this.getOptions());
    }

    public SearchElement[] getAddElements() {
        return (SearchElement[])this.elements.stream().filter(SearchElement::isAdd).toArray(SearchElement[]::new);
    }

    public SearchElement[] getInputElements() {
        return (SearchElement[])this.elements.stream().filter(SearchElement::isUse).toArray(SearchElement[]::new);
    }

    public void addInputElement(SearchElement element) {
        if (!this.elements.contains((Object)element)) {
            element.setUse(true);
            this.elements.add(element);
            this.elementsTable.explore(this.elements.iterator());
        }
        this.setSearchEnabled();
    }

    protected void setSearchEnabled() {
        if (this.hasElements(true)) {
            this.searchAction.setEnabled(true);
        } else {
            this.searchAction.setEnabled(false);
        }
    }

    public void addOutputElements(SearchElement[] newElements) {
        if (newElements != null) {
            for (SearchElement se : newElements) {
                int pos = this.elements.indexOf((Object)se);
                if (pos > -1) {
                    SearchElement e = this.elements.get(pos);
                    e.setUse(false);
                    if (e.getLinkedFromPath() != null) continue;
                    e.setLinkedDirection(se.getLinkedDirection());
                    e.setLinkedFromPath(se.getLinkedFromPath());
                    e.setLinkedLength(se.getLinkedLength());
                    e.setLinkedPath(se.getLinkedPath());
                    e.setRelationType(se.getRelationType());
                    continue;
                }
                se.setUse(false);
                this.elements.add(se);
            }
            this.elementsTable.explore(this.elements.iterator());
        }
        if (this.hasElements(false)) {
            this.addToDiagramAction.setEnabled(true);
        } else {
            this.addToDiagramAction.setEnabled(false);
        }
    }

    public SearchElement[] getOutputElements() {
        ArrayList<SearchElement> outputElements = new ArrayList<SearchElement>();
        for (SearchElement se : this.elements) {
            if (se.isUse()) continue;
            outputElements.add(se);
        }
        return outputElements.toArray(new SearchElement[outputElements.size()]);
    }

    public void removeElements() {
        this.elements.clear();
        this.elementsTable.explore(this.elements.iterator());
        this.setSearchEnabled();
    }

    protected boolean hasElements(boolean useStatus) {
        for (SearchElement se : this.elements) {
            if (se.isUse() != useStatus) continue;
            return true;
        }
        return false;
    }

    public boolean isDocumentInTargetSet(DiagramDocument document) {
        return this.targetDiagrams.contains(document);
    }

    public void addDocumentToTargetSet(DiagramDocument document) {
        this.targetDiagrams.add(document);
    }

    public void updateProperties() {
        this.propertiesPane.explore((Object)this.getOptions());
    }
}

