/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.graphsearch;

import biouml.standard.type.Species;
import biouml.workbench.graphsearch.QueryEngineRegistry;
import biouml.workbench.graphsearch.QueryOptions;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.access.core.DataCollection;

public class GraphSearchOptions {
    public static final String TYPE_NEIGHBOURS = "neighbours";
    public static final String TYPE_PATH = "path";
    public static final String TYPE_SET = "set";
    static final String[] searchTypes = new String[]{"neighbours", "path", "set"};
    private QueryOptions queryOptions;
    private TargetOptions targetOptions;
    private String searchType;
    private Species species = Species.getDefaultSpecies(null);

    public GraphSearchOptions(DataCollection<DataCollection<?>> databaseCollection) {
        this.queryOptions = new QueryOptions();
        if (databaseCollection != null) {
            TargetOptions.CollectionRecord[] records = (TargetOptions.CollectionRecord[])databaseCollection.stream(DataCollection.class).filter(dc -> Boolean.parseBoolean(dc.getInfo().getProperty(DataCollectionUtils.GRAPH_SEARCH))).map(DataCollection::getCompletePath).map(path -> new TargetOptions.CollectionRecord(path, false, (String[])QueryEngineRegistry.lookForQueryEngines(new TargetOptions.CollectionRecord(path, true)).keySet().stream().toArray(String[]::new))).toArray(TargetOptions.CollectionRecord[]::new);
            this.targetOptions = new TargetOptions(records);
        }
        this.searchType = TYPE_NEIGHBOURS;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public void setQueryOptions(QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
    }

    public TargetOptions getTargetOptions() {
        return this.targetOptions;
    }

    public void setTargetOptions(TargetOptions targetOptions) {
        this.targetOptions = targetOptions;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    @PropertyName(value="Species")
    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }
}

