/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram.viewpart;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.BeanInfoEx;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.PropertyDescriptorEx;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.swing.PropertyInspectorEx;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.EditorPartSupport;

public class UnitsEditor
extends EditorPartSupport
implements PropertyChangeListener {
    protected EModel executableModel;
    private final PropertyInspectorEx inspector = new PropertyInspectorEx();

    public UnitsEditor(Object model) {
        this.explore(model, null);
    }

    public boolean canExplore(Object model) {
        return model instanceof Diagram && ((Diagram)((Object)model)).getRole() instanceof EModel;
    }

    public JComponent getView() {
        return this.inspector;
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        if (this.executableModel != null) {
            this.executableModel.removePropertyChangeListener(this);
        }
        this.executableModel = ((Diagram)((Object)model)).getRole(EModel.class);
        this.executableModel.addPropertyChangeListener(this);
        try {
            Units units = new Units(this.executableModel);
            this.inspector.explore((Object)units);
        }
        catch (Exception e) {
            System.out.println("Can not explore units for diagram " + model + ", error: " + e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("units")) {
            Units units = new Units(this.executableModel);
            this.inspector.explore((Object)units);
        }
    }

    public static class UnitsBeanInfo
    extends BeanInfoEx {
        public UnitsBeanInfo() {
            super(Units.class, true);
            this.setSubstituteByChild(true);
        }

        public void initProperties() throws Exception {
            PropertyDescriptorEx pde = new PropertyDescriptorEx("units", this.beanClass);
            pde.setChildDisplayName(this.beanClass.getMethod("calcUnitName", Integer.class, Object.class));
            this.add((PropertyDescriptor)pde);
        }
    }

    public static class Units
    extends Option {
        EModel emodel;

        public Units(EModel emodel) {
            this.emodel = emodel;
        }

        @PropertyName(value="Model units")
        public Unit[] getUnits() {
            Map<String, Unit> modelUnits = this.emodel.getUnits();
            return modelUnits.values().toArray(new Unit[modelUnits.size()]);
        }

        public void setUnits(Unit[] units) {
            Unit[] oldValue = this.getUnits();
            HashSet<String> oldNames = new HashSet<String>(this.emodel.getUnits().keySet());
            for (Unit unit : units) {
                this.emodel.addUnit(unit);
                oldNames.remove(unit.getName());
            }
            for (String oldName : oldNames) {
                this.emodel.removeUnit(oldName);
            }
            this.firePropertyChange("units", oldValue, units);
        }

        public String calcUnitName(Integer index, Object unit) {
            return ((Unit)unit).getTitle();
        }
    }
}

