/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram.viewpart;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.plot.PlotsInfo;
import com.developmentontheedge.beans.swing.PropertyInspectorEx;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.EditorPartSupport;
import ru.biosoft.util.DPSUtils;

public class PlotsEditorPart
extends EditorPartSupport
implements PropertyChangeListener {
    public static final String PLOTS = "Plots";
    private EModel executableModel;
    private PlotsInfo plot;
    private final PropertyInspectorEx inspector = new PropertyInspectorEx();

    public boolean canExplore(Object model) {
        return model instanceof Diagram && ((Diagram)((Object)model)).getRole() instanceof EModel;
    }

    public JComponent getView() {
        return this.inspector;
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        if (this.executableModel != null) {
            this.executableModel.removePropertyChangeListener(this);
        }
        this.executableModel = ((Diagram)((Object)model)).getRole(EModel.class);
        this.executableModel.addPropertyChangeListener(this);
        try {
            Object plotsObj = this.executableModel.getParent().getAttributes().getValue(PLOTS);
            if (!(plotsObj instanceof PlotsInfo)) {
                this.plot = new PlotsInfo(this.executableModel);
                this.executableModel.getParent().getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)PLOTS, PlotsInfo.class, (Object)((Object)this.plot)));
            } else {
                this.plot = (PlotsInfo)((Object)plotsObj);
            }
            this.inspector.explore((Object)this.plot);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can not explore plots for diagram " + model, e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.inspector.explore((Object)this.plot);
    }

    public void onClose() {
        try {
            if (this.executableModel != null) {
                this.executableModel.getParent().getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)PLOTS, PlotsInfo.class, (Object)((Object)this.plot)));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error with plot pane.", ex);
        }
    }
}

