/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram.viewpart;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.DAEModelUtilities;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.standard.diagram.CreateReactionDialog;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.ReactionInitialProperties;
import biouml.standard.diagram.ReactionPane;
import biouml.standard.diagram.Util;
import biouml.standard.type.Reaction;
import biouml.workbench.diagram.SetInitialValuesAction;
import biouml.workbench.diagram.viewpart.ConnectionSimple;
import biouml.workbench.diagram.viewpart.MessageBundle;
import biouml.workbench.diagram.viewpart.PortSimple;
import biouml.workbench.diagram.viewpart.ReactionSimple;
import biouml.workbench.diagram.viewpart.SubDiagramSimple;
import biouml.workbench.diagram.viewpart.UnitsEditor;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.swing.table.AbstractRowModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.filter.Filter;
import ru.biosoft.access.support.DataCollectionRowModelAdapter;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.PluggedEditorsTabbedPane;
import ru.biosoft.gui.TabularPropertiesEditor;
import ru.biosoft.gui.ViewPartSupport;
import ru.biosoft.util.DPSUtils;

public class ModelViewPart
extends ViewPartSupport
implements PropertyChangeListener,
DataCollectionListener {
    private static final Logger log = Logger.getLogger(ModelViewPart.class.getName());
    private JTabbedPane tabbedPane = new JTabbedPane(2);
    private EModel emodel;
    protected RemoveParametersAction removeUnusedParametersAction;
    protected DetectParametersAction detectParametersAction;
    protected AddParameterAction addParameterAction;
    protected HighlightAction highlightAction;
    protected HighlightOffAction highlightOffAction;
    protected RemoveSelectedParameterAction removeSelectedParameterAction;
    protected AddToPlotAction addToPlotAction;
    protected SetInitialValuesAction setInitialValuesAction;
    protected AddElementAction addElementAction;

    public ModelViewPart() {
        this.add("Center", this.tabbedPane);
    }

    private void update() {
        Container parent = this.getParent().getParent();
        if (parent instanceof PluggedEditorsTabbedPane) {
            PluggedEditorsTabbedPane pane = (PluggedEditorsTabbedPane)parent;
            pane.updateActions();
            Component c = this.tabbedPane.getSelectedComponent();
            if (c instanceof VariablesTab) {
                if (((VariablesTab)((Object)c)).template instanceof VariableRole) {
                    this.addParameterAction.setEnabled(false);
                    this.removeSelectedParameterAction.setEnabled(false);
                    this.removeUnusedParametersAction.setEnabled(false);
                } else {
                    this.addParameterAction.setEnabled(true);
                    this.removeSelectedParameterAction.setEnabled(true);
                    this.removeUnusedParametersAction.setEnabled(true);
                }
            }
        }
    }

    private void initTabbedPane(EModel emodel) {
        Diagram diagram = emodel.getDiagramElement();
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab("Variables", (Component)((Object)new VariablesTab(emodel.getParameters(), (Object)new Variable("template", null, null))));
        this.tabbedPane.addTab("Entities", (Component)((Object)new VariablesTab(emodel.getEntityRoles(), new VariableRole("template", null, 1.0))));
        this.tabbedPane.addTab("Compartments", (Component)((Object)new VariablesTab(emodel.getCompartmentRoles(), new VariableRole("template", null, 1.0))));
        this.tabbedPane.addTab("Reactions", (Component)((Object)new ReactionsTab(emodel.getDiagramElement(), new ReactionSimple())));
        this.tabbedPane.addTab("Equations", (Component)((Object)new MathTab(emodel, new Equation(null), new RuleFilter())));
        this.tabbedPane.addTab("Functions", (Component)((Object)new MathTab(emodel, new Function(null, "function f() = 0"), null)));
        this.tabbedPane.addTab("Events", (Component)((Object)new MathTab(emodel, new Event(null), null)));
        this.tabbedPane.addTab("Constraints", (Component)((Object)new MathTab(emodel, new Constraint(null), null)));
        this.tabbedPane.addTab("Ports", null, (Component)((Object)new PortsTab(emodel.getDiagramElement(), new PortSimple())));
        if (DiagramUtility.isComposite(diagram)) {
            this.tabbedPane.addTab("Connections", null, (Component)((Object)new ConnectionsTab(diagram, new ConnectionSimple())));
            this.tabbedPane.addTab("Submodels", (Component)((Object)new SubDiagramTab(diagram, new SubDiagramSimple())));
        }
        this.tabbedPane.addTab("Units", new UnitsEditor(this.model).getView());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ModelViewPart.this.update();
            }
        });
        this.update();
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        if (this.emodel != null) {
            this.emodel.removePropertyChangeListener(this);
        }
        if (model != null) {
            ((Diagram)((Object)model)).removeDataCollectionListener(this);
        }
        this.emodel = ((Diagram)((Object)model)).getRole(EModel.class);
        this.emodel.addPropertyChangeListener(this);
        ((Diagram)((Object)model)).addDataCollectionListener(this);
        this.emodel.detectVariableTypes();
        this.initTabbedPane(this.emodel);
    }

    public boolean canExplore(Object model) {
        return model instanceof Diagram && ((Diagram)((Object)model)).getRole() instanceof EModel;
    }

    public Action[] getActions() {
        Component c = this.tabbedPane.getSelectedComponent();
        ActionManager actionManager = Application.getActionManager();
        if (this.highlightAction == null) {
            this.highlightAction = new HighlightAction();
            actionManager.addAction("highlight diagram nodes containing selected parameters", (Action)this.highlightAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.highlightAction, "highlight diagram nodes containing selected parameters");
        }
        if (this.highlightOffAction == null) {
            this.highlightOffAction = new HighlightOffAction();
            actionManager.addAction("highlight diagram nodes containing selected parameters", (Action)this.highlightOffAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.highlightOffAction, "clear diagram highlight");
        }
        if (c instanceof VariablesTab) {
            if (this.removeUnusedParametersAction == null) {
                this.removeUnusedParametersAction = new RemoveParametersAction();
                actionManager.addAction("Remove unused parameters", (Action)this.removeUnusedParametersAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.removeUnusedParametersAction, "Remove unused parameters");
            }
            if (this.addParameterAction == null) {
                this.addParameterAction = new AddParameterAction();
                actionManager.addAction("Add parameter", (Action)this.addParameterAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.addParameterAction, "Add parameter");
            }
            if (this.detectParametersAction == null) {
                this.detectParametersAction = new DetectParametersAction();
                actionManager.addAction("Detect parameter types", (Action)this.detectParametersAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.detectParametersAction, "Detect parameter types");
            }
            if (this.removeSelectedParameterAction == null) {
                this.removeSelectedParameterAction = new RemoveSelectedParameterAction("parameter");
                actionManager.addAction("remove selected", (Action)this.removeSelectedParameterAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.removeSelectedParameterAction, "remove selected");
            }
            if (this.addToPlotAction == null) {
                this.addToPlotAction = new AddToPlotAction("parameter");
                actionManager.addAction("add to plot", (Action)this.addToPlotAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.addToPlotAction, "add to plot");
            }
            if (this.setInitialValuesAction == null) {
                this.setInitialValuesAction = new SetInitialValuesAction(log){

                    @Override
                    protected void setValue(DataElement de, double value) {
                        ((Variable)de).setInitialValue(value);
                    }

                    @Override
                    protected Iterator<DataElement> getElementsIterator() {
                        return StreamEx.of((Iterator)ModelViewPart.this.emodel.getVariables().iterator()).map(p -> p).iterator();
                    }
                };
                actionManager.addAction("set initial values", (Action)this.setInitialValuesAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.setInitialValuesAction, "set initial values");
                this.setInitialValuesAction.setEnabled(true);
            }
            return new Action[]{this.addToPlotAction, this.detectParametersAction, this.highlightAction, this.highlightOffAction, this.setInitialValuesAction, this.addParameterAction, this.removeSelectedParameterAction, this.removeUnusedParametersAction};
        }
        if (c instanceof MathTab || c instanceof ReactionsTab) {
            if (this.addElementAction == null) {
                this.addElementAction = new AddElementAction();
                actionManager.addAction("Add new element", (Action)this.addElementAction);
                new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.addElementAction, "Add new element");
            }
            return new Action[]{this.addElementAction, this.highlightAction, this.highlightOffAction};
        }
        if (c instanceof DiagramTab) {
            return new Action[]{this.highlightAction, this.highlightOffAction};
        }
        return new Action[0];
    }

    private void clearDiagramHighlight(Diagram diagram) {
        diagram.recursiveStream().forEach(de -> de.getAttributes().remove("highlight"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof VariablesTab) {
            ((VariablesTab)((Object)component)).update();
        } else if (component instanceof MathTab) {
            ((MathTab)((Object)component)).update();
        } else if (component instanceof ReactionsTab) {
            ((ReactionsTab)((Object)component)).update();
        }
    }

    private void layoutElement(Diagram diagram, Node newNode) {
        diagram.getType().getDiagramViewBuilder().createDiagramView(diagram, ApplicationUtils.getGraphics());
        int maxX = 0;
        int maxY = 0;
        for (Node n : diagram.stream().select(Node.class)) {
            maxX = Math.max(n.getLocation().x + (int)n.getView().getBounds().getWidth(), maxX);
            maxY = Math.max(n.getLocation().y + (int)n.getView().getBounds().getHeight(), maxY);
        }
        if (maxX > maxY) {
            newNode.setLocation(0, maxY + 10);
        } else {
            newNode.setLocation(maxX + 10, 0);
        }
    }

    public void elementAdded(DataCollectionEvent e) throws Exception {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof MathTab) {
            ((MathTab)((Object)component)).update();
        } else if (component instanceof ReactionsTab) {
            ((ReactionsTab)((Object)component)).update();
        }
    }

    public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementChanged(DataCollectionEvent e) throws Exception {
    }

    public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementRemoved(DataCollectionEvent e) throws Exception {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof MathTab) {
            ((MathTab)((Object)component)).update();
        }
    }

    public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public static class RuleFilter
    extends EModel.NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            Equation role = de.getRole(Equation.class);
            return !(role.getDiagramElement().getKernel() instanceof Reaction) && !(role.getDiagramElement() instanceof Edge);
        }
    }

    public class AddElementAction
    extends AbstractAction {
        public static final String KEY = "Add new element";

        public AddElementAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Diagram diagram = ModelViewPart.this.emodel.getParent();
            Component c = ModelViewPart.this.tabbedPane.getSelectedComponent();
            if (c instanceof MathTab) {
                MathTab tab = (MathTab)((Object)ModelViewPart.this.tabbedPane.getSelectedComponent());
                DiagramElementGroup deg = diagram.getType().getSemanticController().createInstance((Compartment)diagram, tab.getTemplate().getClass(), new Point(), tab.getTemplate());
                Node newNode = deg.nodesStream().findAny().orElse(null);
                if (newNode != null) {
                    diagram.put(newNode);
                    ModelViewPart.this.layoutElement(diagram, newNode);
                }
                ModelViewPart.this.document.update();
                ((MathTab)((Object)c)).update();
            } else if (c instanceof ReactionsTab) {
                Object properties = diagram.getType().getSemanticController().getPropertiesByType(diagram, Reaction.class, new Point());
                ViewPane pane = ModelViewPart.this.document.getViewPane();
                ViewEditorPane editorPane = (ViewEditorPane)pane;
                new CreateReactionDialog((JFrame)Application.getApplicationFrame(), new ReactionPane(diagram, (Compartment)diagram, new Point(), editorPane, (ReactionInitialProperties)properties));
                ((ReactionsTab)((Object)c)).update();
            }
        }
    }

    public class AddToPlotAction
    extends AbstractAction {
        public static final String KEY = "add to plot";

        public AddToPlotAction(String type) {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesTab tab = (VariablesTab)((Object)ModelViewPart.this.tabbedPane.getSelectedComponent());
            int[] rowr = tab.getTable().getSelectedRows();
            Diagram diagram = (Diagram)((Object)ModelViewPart.this.model);
            PlotsInfo plotsInfo = DiagramUtility.getPlotsInfo(diagram);
            PlotInfo plotInfo = null;
            if (plotsInfo.getPlots().length >= 1) {
                plotInfo = plotsInfo.getPlots()[0];
            } else if (plotsInfo.getPlots().length == 0) {
                plotInfo = new PlotInfo(diagram.getRole(EModel.class));
                plotsInfo.setPlots(new PlotInfo[]{plotInfo});
            }
            Curve[] curves = plotInfo.getYVariables();
            Set alreadyExisting = StreamEx.of((Object[])curves).map(curve -> curve.getName()).toSet();
            Set vars = IntStreamEx.of((int[])rowr).mapToObj(row -> tab.getModelForRow(row)).select(Variable.class).toSet();
            ArrayList<Curve> addCurves = new ArrayList<Curve>();
            for (Variable var : vars) {
                if (alreadyExisting.contains(var.getName())) continue;
                addCurves.add(new Curve("", var.getName(), var.getTitle(), diagram.getRole(EModel.class)));
            }
            Curve[] newCurves = new Curve[curves.length + addCurves.size()];
            System.arraycopy(curves, 0, newCurves, 0, curves.length);
            for (int i = 0; i < addCurves.size(); ++i) {
                newCurves[curves.length + i] = (Curve)((Object)addCurves.get(i));
            }
            plotInfo.setYVariables(newCurves);
        }
    }

    public class RemoveSelectedParameterAction
    extends AbstractAction {
        public static final String KEY = "remove selected";
        private String type;

        public RemoveSelectedParameterAction(String type) {
            super(KEY);
            this.type = "parameter";
            this.type = type;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesTab tab = (VariablesTab)((Object)ModelViewPart.this.tabbedPane.getSelectedComponent());
            int[] rowr = tab.getTable().getSelectedRows();
            HashSet<Variable> vars = new HashSet<Variable>();
            if (rowr.length > 0) {
                for (int i = 0; i < rowr.length; ++i) {
                    Object mod = tab.getModelForRow(rowr[i]);
                    if (mod == null || !(mod instanceof Variable)) continue;
                    vars.add((Variable)((Object)mod));
                }
            }
            if (vars.size() > 0) {
                Diagram diagram = (Diagram)((Object)ModelViewPart.this.model);
                for (Variable var : vars) {
                    if (var instanceof VariableRole) {
                        DiagramElement[] nodes;
                        for (DiagramElement de : nodes = ((VariableRole)var).getAssociatedElements()) {
                            try {
                                diagram.getType().getSemanticController().remove(de);
                            }
                            catch (Exception e1) {
                                log.log(Level.INFO, "Can not remove element " + de.getName(), e1);
                            }
                        }
                        continue;
                    }
                    String variableName = var.getName();
                    try {
                        ModelViewPart.this.emodel.getVariables().remove(variableName);
                    }
                    catch (Exception ex) {
                        log.info("Can not remove " + this.type + " " + variableName);
                    }
                }
                ModelViewPart.this.document.update();
            }
        }
    }

    public class HighlightOffAction
    extends AbstractAction {
        public static final String KEY = "clear diagram highlight";

        public HighlightOffAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Diagram diagram = (Diagram)((Object)ModelViewPart.this.model);
            ModelViewPart.this.clearDiagramHighlight(diagram);
            ModelViewPart.this.document.update();
        }
    }

    public class HighlightAction
    extends AbstractAction {
        public static final String KEY = "highlight diagram nodes containing selected parameters";

        public HighlightAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component component = ModelViewPart.this.tabbedPane.getSelectedComponent();
            if (component instanceof TabularPropertyInspector) {
                TabularPropertyInspector tab = (TabularPropertyInspector)ModelViewPart.this.tabbedPane.getSelectedComponent();
                int[] rowr = tab.getTable().getSelectedRows();
                HashSet<Object> elements = new HashSet<Object>();
                if (rowr.length > 0) {
                    for (int i = 0; i < rowr.length; ++i) {
                        Object mod = tab.getModelForRow(rowr[i]);
                        if (!(mod instanceof Role) && !(mod instanceof Variable) && !(mod instanceof ReactionSimple) && !(mod instanceof PortSimple) && !(mod instanceof ConnectionSimple) && !(mod instanceof SubDiagramSimple)) continue;
                        elements.add(mod);
                    }
                }
                Diagram diagram = (Diagram)((Object)ModelViewPart.this.model);
                ModelViewPart.this.clearDiagramHighlight(diagram);
                if (elements.isEmpty()) {
                    return;
                }
                ArrayList<DiagramElement> des = new ArrayList<DiagramElement>();
                if (tab instanceof VariablesTab) {
                    Set names = StreamEx.of(elements).map(r -> ((Variable)((Object)((Object)r))).getName()).toSet();
                    for (DiagramElement de : diagram.recursiveStream()) {
                        if (!DAEModelUtilities.hasVariables(de, names)) continue;
                        des.add(de);
                    }
                } else if (tab instanceof MathTab) {
                    if (((MathTab)tab).getTemplate() instanceof Function) {
                        for (DiagramElement de : diagram.recursiveStream()) {
                            if (!DAEModelUtilities.hasFunction(de, StreamEx.of(elements).select(Function.class).map(f -> f.getName()).toSet())) continue;
                            des.add(de);
                        }
                    }
                    for (Object role : elements) {
                        des.add(((Role)role).getDiagramElement());
                    }
                } else if (tab instanceof ReactionsTab) {
                    for (Object obj : elements) {
                        Reaction r2 = ((ReactionSimple)obj).getReaction();
                        Option parent = r2.getParent();
                        if (!(parent instanceof Node)) continue;
                        Node n = (Node)parent;
                        des.add(n);
                        for (Edge edge : n.edges()) {
                            if (!Util.isSpecieReference(edge)) continue;
                            des.add(edge);
                            des.add(edge.getOtherEnd(n));
                        }
                    }
                } else if (tab instanceof ConnectionsTab) {
                    for (Object obj : elements) {
                        des.add(((ConnectionSimple)obj).connection);
                    }
                } else if (tab instanceof PortsTab) {
                    for (Object obj : elements) {
                        Node node = ((PortSimple)obj).getPort();
                        des.add(node);
                        for (Edge edge : node.getEdges()) {
                            des.add(edge);
                        }
                    }
                } else if (tab instanceof SubDiagramTab) {
                    for (Object obj : elements) {
                        des.add(((SubDiagramSimple)obj).getSubDiagram());
                    }
                }
                for (DiagramElement de : des) {
                    de.getAttributes().add(DPSUtils.createTransient((String)"highlight", Boolean.class, (Object)true));
                }
            }
            ModelViewPart.this.document.update();
        }
    }

    public class AddParameterAction
    extends AbstractAction {
        public static final String KEY = "Add parameter";

        public AddParameterAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String baseName = "parameter";
            int i = 2;
            String name = baseName + "_1";
            while (ModelViewPart.this.emodel.containsVariable(name)) {
                name = baseName + "_" + i++;
            }
            ModelViewPart.this.emodel.declareVariable(name, new Double(0.0));
        }
    }

    public class DetectParametersAction
    extends AbstractAction {
        public static final String KEY = "Detect parameter types";

        public DetectParametersAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelViewPart.this.emodel.detectVariableTypes();
        }
    }

    public class RemoveParametersAction
    extends AbstractAction {
        public static final String KEY = "Remove unused parameters";

        public RemoveParametersAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelViewPart.this.emodel.removeNotUsedParameters();
        }
    }

    static class ListRowModel
    extends AbstractRowModel {
        private List<?> roles;
        private Class c;

        public ListRowModel(List<?> roles, Class c) {
            this.roles = roles;
            this.c = c;
        }

        public int size() {
            return this.roles.size();
        }

        public Object getBean(int index) {
            return this.roles.get(index);
        }

        public Class<?> getBeanClass() {
            return this.c;
        }
    }

    public static class MathTab
    extends TabularPropertiesEditor {
        private Role template;
        private EModel emodel;
        private Filter<DiagramElement> filter;

        public MathTab(EModel emodel, Role template, Filter<DiagramElement> filter) {
            this.template = template;
            this.emodel = emodel;
            this.filter = filter;
            this.update();
            this.setDefaultNumberFormat(null);
        }

        public Role getTemplate() {
            return this.template;
        }

        public void update() {
            List list = null;
            list = this.filter == null ? this.emodel.getChildrenRoles(this.emodel.getParent(), this.template.getClass()).toList() : this.emodel.getChildrenRoles(this.emodel.getParent(), this.template.getClass(), this.filter).toList();
            this.explore((RowModel)new ListRowModel(list, this.template.getClass()), this.template, 0);
            this.getTable().setAutoResizeMode(4);
        }
    }

    public static class ConnectionsTab
    extends DiagramTab<ConnectionSimple> {
        public ConnectionsTab(Diagram diagram, ConnectionSimple template) {
            super(diagram, template);
        }

        @Override
        public List<ConnectionSimple> getObjects() {
            return DiagramUtility.getConnections(this.diagram).map(n -> new ConnectionSimple((Edge)((Object)n))).toList();
        }
    }

    public static class SubDiagramTab
    extends DiagramTab<SubDiagramSimple> {
        public SubDiagramTab(Diagram diagram, SubDiagramSimple template) {
            super(diagram, template);
        }

        @Override
        public List<SubDiagramSimple> getObjects() {
            return DiagramUtility.getSubDiagrams(this.diagram).map(n -> new SubDiagramSimple((SubDiagram)((Object)n))).toList();
        }
    }

    public static class PortsTab
    extends DiagramTab<PortSimple> {
        public PortsTab(Diagram diagram, PortSimple template) {
            super(diagram, template);
        }

        @Override
        public List<PortSimple> getObjects() {
            return DiagramUtility.getTopLevelPorts(this.diagram).map(n -> new PortSimple((Node)((Object)n))).toList();
        }
    }

    public static class ReactionsTab
    extends DiagramTab<ReactionSimple> {
        public ReactionsTab(Diagram diagram, ReactionSimple template) {
            super(diagram, template);
        }

        @Override
        public List<ReactionSimple> getObjects() {
            return StreamEx.of(DiagramUtility.getReactions(this.diagram)).map(r -> new ReactionSimple((Reaction)r)).toList();
        }
    }

    public static abstract class DiagramTab<T>
    extends TabularPropertiesEditor {
        protected Diagram diagram;
        private T template;

        public DiagramTab(Diagram diagram, T template) {
            this.template = template;
            this.diagram = diagram;
            List<T> list = this.getObjects();
            this.explore((RowModel)new ListRowModel(list, this.template.getClass()), this.template, 0);
            this.getTable().setAutoResizeMode(4);
            this.setDefaultNumberFormat(null);
        }

        public void update() {
            List<T> list = this.getObjects();
            this.explore((RowModel)new ListRowModel(list, this.template.getClass()), this.template, 0);
            this.getTable().setAutoResizeMode(4);
        }

        public abstract List<T> getObjects();
    }

    public static class VariablesTab
    extends TabularPropertiesEditor {
        private DataCollection<? extends Variable> dc;
        protected Object template;

        public VariablesTab(DataCollection<? extends Variable> dc, Object template) {
            this.dc = dc;
            this.template = template;
            this.explore((RowModel)new DataCollectionRowModelAdapter(dc), template, 0);
            this.getTable().setAutoResizeMode(1);
            this.setDefaultNumberFormat(null);
        }

        public void update() {
            this.explore((RowModel)new DataCollectionRowModelAdapter(this.dc), this.template, 0);
            this.getTable().setAutoResizeMode(4);
        }
    }
}

