/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram.action;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.subaction.BackgroundDynamicAction;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;

public class SaveDiagramSubsetAction
extends BackgroundDynamicAction {
    public boolean isApplicable(Object model) {
        return model instanceof Diagram && !((Diagram)((Object)model)).getType().getClass().toString().endsWith("AnnotationDiagramType");
    }

    public JobControl getJobControl(final Object model, final List<DataElement> selectedItems, Object properties) throws Exception {
        final DataElementPath target = (DataElementPath)((DynamicPropertySet)properties).getValue("target");
        return new AbstractJobControl(this.log){

            protected void doRun() throws JobControlException {
                try {
                    Diagram diagram = (Diagram)((Object)model);
                    Diagram result = diagram.clone(target.getParentCollection(), target.getName());
                    this.setPreparedness(50);
                    HashSet<String> names = new HashSet<String>();
                    for (DataElement item : selectedItems) {
                        names.add(((DiagramElement)item.cast(DiagramElement.class)).getCompleteNameInDiagram());
                    }
                    this.setPreparedness(52);
                    this.retainElements(result, names);
                    this.setPreparedness(80);
                    CollectionFactoryUtils.save((DataElement)result);
                    this.setPreparedness(100);
                    this.resultsAreReady(new Object[]{result});
                }
                catch (Exception e) {
                    throw new JobControlException((Throwable)e);
                }
            }

            private void retainElements(Compartment compartment, Set<String> retain) throws Exception {
                for (String name : compartment.getNameList().toArray(new String[compartment.getSize()])) {
                    Compartment c;
                    DiagramElement de = compartment.get(name);
                    if (de == null || de instanceof Edge || retain.contains(de.getCompleteNameInDiagram())) continue;
                    if (de instanceof Compartment && (c = (Compartment)de).getSize() > 0) {
                        this.retainElements(c, retain);
                        if (c.getSize() > 0) continue;
                    }
                    if (de instanceof Node) {
                        Node n = (Node)de;
                        for (Edge e : n.getEdges()) {
                            e.getOrigin().remove(e.getName());
                        }
                    }
                    compartment.remove(de.getName());
                }
            }
        };
    }

    public Object getProperties(Object model, List<DataElement> selectedItems) {
        return this.getTargetProperties(Diagram.class, DataElementPath.create((String)(((Diagram)((Object)model)).getCompletePath() + " subset")).uniq());
    }
}

