/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram.action;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.util.ImageGenerator;
import biouml.workbench.diagram.action.ProcessNodesAction;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DistributeHorizontalAction
extends ProcessNodesAction {
    @Override
    void processNodes(Diagram diagram, List<Node> nodes) {
        if (nodes.size() <= 2) {
            return;
        }
        diagram.setView(null);
        ImageGenerator.generateDiagramView(diagram, ApplicationUtils.getGraphics());
        Collections.sort(nodes, Comparator.comparingDouble(node -> node.getView().getBounds().getCenterX()));
        double totalLength = 0.0;
        double minPos = nodes.get(0).getView().getBounds().getMinX();
        double maxPos = nodes.get(0).getView().getBounds().getMaxX();
        for (Node node2 : nodes) {
            Rectangle bounds = node2.getView().getBounds();
            minPos = Math.min(minPos, bounds.getMinX());
            maxPos = Math.max(maxPos, bounds.getMaxX());
            totalLength += bounds.getWidth();
        }
        double delta = (maxPos - minPos - totalLength) / (double)(nodes.size() - 1);
        double pos = nodes.get(0).getView().getBounds().getMaxX();
        SemanticController sc = diagram.getType().getSemanticController();
        for (int i = 1; i < nodes.size() - 1; ++i) {
            diagram.setView(null);
            ImageGenerator.generateDiagramView(diagram, ApplicationUtils.getGraphics());
            Node node3 = nodes.get(i);
            int offset = (int)((pos += delta) - node3.getView().getBounds().getMinX());
            pos += node3.getView().getBounds().getWidth();
            if (offset == 0) continue;
            try {
                sc.move(node3, (Compartment)node3.getOrigin(), new Dimension(offset, 0), node3.getView().getBounds());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

