/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram.action;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.util.ImageGenerator;
import biouml.workbench.diagram.action.ProcessNodesAction;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Dimension;
import java.util.List;

public class AlignCenterXAction
extends ProcessNodesAction {
    @Override
    void processNodes(Diagram diagram, List<Node> nodes) {
        diagram.setView(null);
        ImageGenerator.generateDiagramView(diagram, ApplicationUtils.getGraphics());
        double minPos = nodes.get(0).getView().getBounds().getMinX();
        double maxPos = nodes.get(0).getView().getBounds().getMaxX();
        for (Node node : nodes) {
            minPos = Math.min(minPos, node.getView().getBounds().getMinX());
            maxPos = Math.max(maxPos, node.getView().getBounds().getMaxX());
        }
        double midPos = (maxPos + minPos) / 2.0;
        SemanticController sc = diagram.getType().getSemanticController();
        for (Node node : nodes) {
            diagram.setView(null);
            ImageGenerator.generateDiagramView(diagram, ApplicationUtils.getGraphics());
            int offset = (int)(midPos - node.getView().getBounds().getCenterX());
            if (offset == 0) continue;
            try {
                sc.move(node, (Compartment)node.getOrigin(), new Dimension(offset, 0), node.getView().getBounds());
            }
            catch (Exception exception) {}
        }
    }
}

