/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Edge;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.application.Application;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.util.OkCancelDialog;

public class VertexTypeDialog
extends OkCancelDialog {
    protected JRadioButton radio1;
    protected JRadioButton radio2;
    protected JRadioButton radio3;
    protected Edge edge;
    protected int point;
    protected ViewPane viewPane;

    public VertexTypeDialog(ViewPane viewPane, Edge edge, int point, int type) {
        super((Component)Application.getApplicationFrame(), "Vertex type");
        this.viewPane = viewPane;
        this.edge = edge;
        this.point = point;
        JPanel mainPanel = new JPanel(new GridLayout(3, 1));
        this.radio1 = new JRadioButton("line");
        this.radio1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VertexTypeDialog.this.setSelectedRadio(0);
            }
        });
        mainPanel.add(this.radio1);
        this.radio2 = new JRadioButton("quadric");
        this.radio2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VertexTypeDialog.this.setSelectedRadio(1);
            }
        });
        mainPanel.add(this.radio2);
        this.radio3 = new JRadioButton("cubic");
        this.radio3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VertexTypeDialog.this.setSelectedRadio(2);
            }
        });
        mainPanel.add(this.radio3);
        this.setSelectedRadio(type);
        this.setContent(mainPanel);
    }

    protected void setSelectedRadio(int type) {
        if (type == 0) {
            this.radio1.setSelected(true);
            this.radio2.setSelected(false);
            this.radio3.setSelected(false);
        } else if (type == 1) {
            this.radio1.setSelected(false);
            this.radio2.setSelected(true);
            this.radio3.setSelected(false);
        } else {
            this.radio1.setSelected(false);
            this.radio2.setSelected(false);
            this.radio3.setSelected(true);
        }
    }

    protected void okPressed() {
        Path path = this.edge.getPath();
        int type = 0;
        if (this.radio2.isSelected()) {
            type = 1;
        } else if (this.radio3.isSelected()) {
            type = 2;
        }
        path.pointTypes[this.point] = type;
        DiagramDocument.updateDiagram(this.viewPane, this.edge);
        super.okPressed();
    }
}

